/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.core.breakpoints;

import com.ibm.debug.pdt.core.breakpoints.BreakpointLabels;
import com.ibm.debug.pdt.core.breakpoints.PICLLocationBreakpoint;
import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.AddressBreakpoint;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;

public class PICLAddressBreakpoint
extends PICLLocationBreakpoint {
    public PICLAddressBreakpoint() {
    }

    public PICLAddressBreakpoint(AddressBreakpoint bkpt, PDTDebugTarget dbgtgt) throws CoreException {
        super(bkpt, dbgtgt);
    }

    @Override
    public String getLabel() {
        String addressString = this.getAddress();
        if (addressString == null) {
            addressString = BreakpointLabels.unknown_breakpoint_type_label;
        }
        return this.bindLabel(BreakpointLabels.address_breakpoint_type_label, addressString);
    }

    public String getAddress() {
        String address = null;
        address = this.isImported() ? this.getMarker().getAttribute("address", null) : ((AddressBreakpoint)this.fBreakpoint).getAddress();
        return address;
    }

    @Override
    protected String getMarkerType() {
        return "com.ibm.debug.pdt.core.PICLAddressBreakpoint";
    }

    @Override
    Map<String, Object> getAttributes(Breakpoint bkpt, PDTDebugTarget dbgtgt) {
        AddressBreakpoint addressBkpt = (AddressBreakpoint)bkpt;
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("org.eclipse.debug.core.enabled", addressBkpt.isEnabled());
        attributes.put("lineNumber", this.getMarkerLineNumber(addressBkpt, dbgtgt));
        attributes.put("address", addressBkpt.getAddress());
        return attributes;
    }

    @Override
    public void createModelBreakpoint(IMarker marker, DebuggeeProcess process) {
        OptionalBreakpointData optBpData;
        String address = null;
        boolean enabled = false;
        try {
            enabled = marker.getAttribute("org.eclipse.debug.core.enabled", true);
            enabled = enabled && DebugPlugin.getDefault().getBreakpointManager().isEnabled();
            address = this.getAttributeAsString(marker, "address");
            optBpData = new OptionalBreakpointData(marker);
        }
        catch (CoreException e) {
            return;
        }
        try {
            process.setAddressBreakpoint(enabled, address, null, optBpData, PICLAddressBreakpoint.getMarkerAsProperty(marker), this.getMarkerType().equals("com.ibm.debug.pdt.core.PICLAddressRangeBreakpoint"));
        }
        catch (EngineRequestException e) {
            PDTCoreUtils.logString(this, "Import of breakpoint failed", 1);
        }
    }
}

