/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.core.breakpoints;

import com.ibm.debug.pdt.core.breakpoints.BreakpointLabels;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.LineBreakpoint;
import org.eclipse.osgi.util.NLS;

public abstract class GenericLineBreakpoint
extends LineBreakpoint {
    private boolean fHasBeenProcessed = false;
    private static final String INSTALL_COUNT = "com.ibm.debug.pdt.core.installCount";

    public String getModelIdentifier() {
        return "com.ibm.debug.pdt.common";
    }

    public void setMarker(IMarker marker) throws CoreException {
        super.setMarker(marker);
        this.resetInstallCount();
    }

    public void registerBreakpoint() throws CoreException {
        DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)this);
    }

    public boolean hasBeenProcessed() {
        return this.fHasBeenProcessed;
    }

    public void markAsProcessed(boolean hasBeenProcessed) {
        this.fHasBeenProcessed = hasBeenProcessed;
    }

    public boolean isInstalled() {
        return this.getInstallCount() > 0;
    }

    public int getInstallCount() {
        if (this.getMarker() == null) {
            return 0;
        }
        return this.getMarker().getAttribute(INSTALL_COUNT, 0);
    }

    public synchronized int incrementInstallCount() throws CoreException {
        int installCount = this.getInstallCount() + 1;
        this.setAttribute(INSTALL_COUNT, installCount);
        return installCount;
    }

    public synchronized int decrementInstallCount() throws CoreException {
        int installCount = this.getInstallCount();
        if (installCount == 0) {
            return 0;
        }
        this.setAttribute(INSTALL_COUNT, --installCount);
        return installCount;
    }

    private void resetInstallCount() {
        try {
            this.setAttribute(INSTALL_COUNT, 0);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public String getLabel() {
        if (!this.getModelIdentifier().equals("com.ibm.debug.pdt.common")) {
            return null;
        }
        IMarker marker = this.getMarker();
        if (marker == null) {
            return BreakpointLabels.unknown_breakpoint_type_label;
        }
        try {
            String label = "";
            IResource resource = marker.getResource();
            String fileName = (String)marker.getAttribute("fileName");
            if (resource instanceof IFile && fileName == null) {
                String string = fileName = resource.getLocation() == null ? resource.getName() : resource.getLocation().lastSegment();
            }
            if (marker.isSubtypeOf("com.ibm.debug.pdt.common.GenericLineBreakpointMarker")) {
                Object[] args = new String[2];
                int line = marker.getAttribute("lineNumber", -1);
                args[0] = fileName;
                args[1] = Integer.toString(line);
                label = NLS.bind((String)BreakpointLabels.generic_breakpoint_label_format, (Object[])args);
            }
            return label;
        }
        catch (CoreException e) {
            PDTCoreUtils.logError((Exception)((Object)e));
            return BreakpointLabels.unknown_breakpoint_type_label;
        }
    }
}

