/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.core;

import com.ibm.debug.pdt.core.IMessageEvent;
import com.ibm.debug.pdt.core.IMessageListener;
import com.ibm.debug.pdt.core.IPDTDebugTarget;
import com.ibm.debug.pdt.core.IPDTDebuggerEngine;
import com.ibm.debug.pdt.core.IPDTzPICLDebuggerEngine;
import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.epdc.ECPLog;
import com.ibm.debug.pdt.internal.epdc.ERepCommandLog;
import com.ibm.debug.pdt.internal.epdc.EStdCmdLogLine;
import com.ibm.debug.pdt.internal.epdc.EStdHiddenCmdLogLine;
import com.ibm.debug.pdt.internal.epdc.EStdLogLine;
import com.ibm.debug.pdt.internal.epdc.EStdPgmErrorLine;
import com.ibm.debug.pdt.internal.epdc.EStdPgmOutputLine;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;

public class PDTDebugUtils {
    public static final int ConsoleInputTypeCommand = 1;
    public static final int ConsoleInputTypeHiddenCommand = 2;
    public static final int ConsoleInputTypePgmIO = 3;
    public static final int ERROR = 1;
    public static final int INFORMATION = 2;
    public static final int QUESTION = 3;
    public static final int WARNING = 4;
    private static ArrayList<IMessageListener> fMessageListeners = new ArrayList();

    public static boolean supportsConsoleInputType(IDebugTarget dbgtgt, int requestType) {
        if (dbgtgt == null || !(dbgtgt instanceof PDTDebugTarget)) {
            return false;
        }
        switch (requestType) {
            case 1: {
                return ((PDTDebugTarget)dbgtgt).supportsCommandLog();
            }
            case 2: {
                return ((PDTDebugTarget)dbgtgt).supportsHiddenCommandLog();
            }
            case 3: {
                return ((PDTDebugTarget)dbgtgt).supportsProgramIO();
            }
        }
        return false;
    }

    public static String[] processConsoleInput(IDebugTarget dbgtgt, int requestType, String commandInput) throws DebugException {
        return PDTDebugUtils.processConsoleInput(dbgtgt, requestType, commandInput, true);
    }

    public static String[] processConsoleInput(IDebugTarget debugTarget, int requestType, String commandInput, boolean isImmediate) throws DebugException {
        ERepCommandLog reply;
        PDTDebugTarget target = null;
        if (!PDTDebugUtils.supportsConsoleInputType(debugTarget, requestType)) {
            throw new DebugException((IStatus)new Status(4, "com.ibm.debug.pdt.core", 5011, PICLMessages.FeatureNotSupported, null));
        }
        target = (PDTDebugTarget)debugTarget;
        DebugEngine debugEngine = target.getDebugEngine();
        if (target.isTerminated() || debugEngine == null) {
            throw new DebugException((IStatus)new Status(4, "com.ibm.debug.pdt.core", 5012, PICLMessages.picl_debug_target_warning_engine_is_terminated, null));
        }
        try {
            switch (requestType) {
                case 1: {
                    reply = debugEngine.commandLog(commandInput, false, isImmediate);
                    break;
                }
                case 2: {
                    reply = debugEngine.commandLog(commandInput, true, isImmediate);
                    break;
                }
                default: {
                    throw new DebugException((IStatus)new Status(4, "com.ibm.debug.pdt.core", 5011, PICLMessages.FeatureNotSupported, null));
                }
            }
        }
        catch (EngineRequestException ere) {
            throw new DebugException((IStatus)new Status(4, "com.ibm.debug.pdt.core", 5010, ere.getMessage(), (Throwable)ere));
        }
        ArrayList<String> lines2Return = new ArrayList<String>();
        ECPLog[] eCPLogArray = reply.getLogChanges();
        int n = eCPLogArray.length;
        int n2 = 0;
        while (n2 < n) {
            ECPLog log = eCPLogArray[n2];
            EStdLogLine[] eStdLogLineArray = log.getLogLines();
            int n3 = eStdLogLineArray.length;
            int n4 = 0;
            while (n4 < n3) {
                EStdLogLine logLine = eStdLogLineArray[n4];
                if (logLine != null) {
                    if (logLine instanceof EStdCmdLogLine && requestType == 1) {
                        lines2Return.add(logLine.getLogLineString());
                    } else if (logLine instanceof EStdHiddenCmdLogLine && requestType == 2) {
                        lines2Return.add(logLine.getLogLineString());
                    } else if ((logLine instanceof EStdPgmOutputLine || logLine instanceof EStdPgmErrorLine) && requestType == 3) {
                        lines2Return.add(logLine.getLogLineString());
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return lines2Return.toArray(new String[lines2Return.size()]);
    }

    public static boolean isTPF41Engine(IDebugTarget dbgtgt) {
        if (!(dbgtgt instanceof PDTDebugTarget)) {
            return false;
        }
        try {
            return ((PDTDebugTarget)dbgtgt).getEngineSession().isTPF41engine();
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    public static boolean iszTPFEngine(IDebugTarget dbgtgt) {
        if (!(dbgtgt instanceof PDTDebugTarget)) {
            return false;
        }
        try {
            return ((PDTDebugTarget)dbgtgt).getEngineSession().iszTPFengine();
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    public static boolean isDebugToolEngine(IDebugTarget dbgtgt) {
        if (!(dbgtgt instanceof PDTDebugTarget)) {
            return false;
        }
        try {
            return ((PDTDebugTarget)dbgtgt).getEngineSession().isDebugTool();
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    public static boolean iszPICLEngine(IDebugTarget dbgtgt) {
        if (!(dbgtgt instanceof PDTDebugTarget)) {
            return false;
        }
        try {
            return ((PDTDebugTarget)dbgtgt).getEngineSession().iszPICL();
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    public static boolean isSLDEngine(IDebugTarget dbgtgt) {
        if (!(dbgtgt instanceof PDTDebugTarget)) {
            return false;
        }
        try {
            return ((PDTDebugTarget)dbgtgt).getEngineSession().isSLD();
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    public static boolean isDBXEngine(IDebugTarget dbgtgt) {
        if (!(dbgtgt instanceof PDTDebugTarget)) {
            return false;
        }
        try {
            return ((PDTDebugTarget)dbgtgt).getEngineSession().isDBX();
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    public static boolean isiSeriesEngine(IDebugTarget dbgtgt) {
        if (!(dbgtgt instanceof PDTDebugTarget)) {
            return false;
        }
        try {
            return ((PDTDebugTarget)dbgtgt).getEngineSession().isiSeriesEngine();
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    public static void cancelAllEPDCDumps() {
        IPDTDebugTarget[] iPDTDebugTargetArray = PDTCorePlugin.getDebugTargets();
        int n = iPDTDebugTargetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPDTDebugTarget dbgtgt = iPDTDebugTargetArray[n2];
            dbgtgt.getDebugEngine().getEngineSession().terminateEPDCDumping(dbgtgt);
            ++n2;
        }
    }

    public static IPDTDebuggerEngine getLocalDebugEngine() {
        return PDTCorePlugin.getLocalPICLEngine();
    }

    public static IPDTzPICLDebuggerEngine getLocalZPICLDebugEngine() {
        return PDTCorePlugin.getLocalZPICLEngine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMessageListener(IMessageListener listener) {
        ArrayList<IMessageListener> arrayList = fMessageListeners;
        synchronized (arrayList) {
            if (!fMessageListeners.contains(listener)) {
                fMessageListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMessageListener(IMessageListener listener) {
        ArrayList<IMessageListener> arrayList = fMessageListeners;
        synchronized (arrayList) {
            fMessageListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireMessageEvent(final Object source, final int severity, final String message) {
        IMessageEvent event = new IMessageEvent(){

            @Override
            public Object getSource() {
                return source;
            }

            @Override
            public int getSeverity() {
                return severity;
            }

            @Override
            public String getMessage() {
                return message;
            }
        };
        ArrayList<IMessageListener> arrayList = fMessageListeners;
        synchronized (arrayList) {
            for (IMessageListener listener : fMessageListeners) {
                listener.messageEventFired(event);
            }
        }
    }
}

