/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.breakpoints.stackpattern.ui.actions;

import com.ibm.debug.breakpoints.stackpattern.IStackPatternLanguageAdapter;
import com.ibm.debug.breakpoints.stackpattern.StackPatternUtils;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class DisableStackPatternAction
implements IObjectActionDelegate {
    private ISelection fSelection;

    public void run(IAction action) {
        if (this.fSelection instanceof IStructuredSelection) {
            IStructuredSelection strucSel = (IStructuredSelection)this.fSelection;
            for (Object selection : strucSel) {
                if (!(selection instanceof IBreakpoint)) continue;
                DisableStackPatternAction.doDisableStackPatternAction(selection);
            }
        }
    }

    public static void doDisableStackPatternAction(Object selection) {
        IBreakpoint breakpoint = (IBreakpoint)selection;
        IStackPatternLanguageAdapter languageAdapter = StackPatternUtils.getLanguageAdapter(breakpoint);
        languageAdapter.setStackPatternEnabled(breakpoint, false);
        if (languageAdapter.isStackPatternEnabled(breakpoint)) {
            languageAdapter.setStackPatternEnabled(breakpoint, false);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
        if (this.fSelection instanceof IStructuredSelection) {
            IStructuredSelection strucSel = (IStructuredSelection)this.fSelection;
            for (Object obj : strucSel) {
                IBreakpoint breakpoint;
                IStackPatternLanguageAdapter languageAdapter;
                if (!(obj instanceof IBreakpoint) || !(languageAdapter = StackPatternUtils.getLanguageAdapter(breakpoint = (IBreakpoint)obj)).isStackPatternEnabled(breakpoint)) continue;
                action.setEnabled(true);
                return;
            }
        }
        action.setEnabled(false);
    }

    public void setActivePart(IAction action, IWorkbenchPart part) {
    }
}

