/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.breakpoints.stackpattern.ui;

import com.ibm.debug.breakpoints.stackpattern.internal.FontReflowUtil;
import com.ibm.debug.breakpoints.stackpattern.internal.SPMessages;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class StackPatternImportDialog
extends TrayDialog {
    public static final int IMPORT_FROM_CURRENT_THREAD = 0;
    public static final int IMPORT_FROM_STACK_TRACE = 1;
    private Button fImportFromCurrentThreadButton;
    private Button fImportFromStackTraceButton;
    private StyledText fStackTraceText;
    private String fStackTraceString;
    private Result fResult;
    private boolean fIsImportFromCurrentThreadEnabled = false;
    private boolean fHasInitialText = true;
    private WidgetListener fListener = new WidgetListener();

    public StackPatternImportDialog(Shell shell, Result result, boolean isImportFromCurrentThreadEnabled) {
        super(shell);
        this.fResult = result;
        this.fIsImportFromCurrentThreadEnabled = isImportFromCurrentThreadEnabled;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        String title = SPMessages.getString("import_dialog_title");
        if (title != null) {
            shell.setText(title);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        container.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        container.setLayoutData((Object)gridData);
        this.fImportFromCurrentThreadButton = new Button(container, 16);
        this.fImportFromCurrentThreadButton.setText(SPMessages.getString("import_dialog_from_current_thread"));
        gridData = new GridData(770);
        this.fImportFromCurrentThreadButton.setLayoutData((Object)gridData);
        this.fImportFromCurrentThreadButton.addSelectionListener((SelectionListener)this.fListener);
        this.fImportFromStackTraceButton = new Button(container, 16);
        this.fImportFromStackTraceButton.setText(SPMessages.getString("import_dialog_enter_stack_trace"));
        gridData = new GridData(770);
        this.fImportFromStackTraceButton.setLayoutData((Object)gridData);
        this.fImportFromStackTraceButton.addSelectionListener((SelectionListener)this.fListener);
        this.fStackTraceText = new StyledText(container, 2818);
        gridData = new GridData(1808);
        gridData.widthHint = 400;
        gridData.heightHint = 300;
        this.fStackTraceText.setLayoutData((Object)gridData);
        this.fStackTraceText.setForeground(this.getShell().getDisplay().getSystemColor(18));
        this.fStackTraceText.setText(SPMessages.getString("import_dialog_initial_prompt"));
        this.fStackTraceText.addFocusListener((FocusListener)this.fListener);
        if (this.fIsImportFromCurrentThreadEnabled) {
            this.fImportFromCurrentThreadButton.setEnabled(true);
            this.fImportFromCurrentThreadButton.setSelection(true);
            this.fImportFromStackTraceButton.setSelection(false);
            this.fStackTraceText.setEnabled(false);
            this.fStackTraceText.setBackground(this.getShell().getDisplay().getSystemColor(19));
        } else {
            this.fImportFromCurrentThreadButton.setEnabled(false);
            this.fImportFromCurrentThreadButton.setSelection(false);
            this.fImportFromStackTraceButton.setSelection(true);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.debug.breakpoints.stackpattern.stack_pattern_breakpoint_import_dialog");
        return container;
    }

    public boolean close() {
        this.fStackTraceString = this.fStackTraceText.getText();
        if (this.fImportFromCurrentThreadButton.getSelection()) {
            this.fResult.setImportSelection(0);
        } else {
            this.fResult.setImportSelection(1);
        }
        return super.close();
    }

    public String getText() {
        return this.fStackTraceString;
    }

    private void handleImportFromCurrentThreadButtonSelected() {
        if (this.fImportFromCurrentThreadButton.isEnabled()) {
            this.fImportFromCurrentThreadButton.setSelection(true);
            this.fImportFromStackTraceButton.setSelection(false);
            this.fStackTraceText.setEnabled(false);
            this.fStackTraceText.setBackground(this.getShell().getDisplay().getSystemColor(19));
        }
    }

    private void handleImportFromStackTraceButtonSelected() {
        this.fImportFromCurrentThreadButton.setSelection(false);
        this.fImportFromStackTraceButton.setSelection(true);
        this.fStackTraceText.setEnabled(true);
        this.fStackTraceText.setBackground(this.getShell().getDisplay().getSystemColor(1));
    }

    protected Control createContents(Composite parent) {
        ScrolledComposite scrolled = new ScrolledComposite(parent, 2816);
        scrolled.setShowFocusedControl(true);
        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)scrolled);
        Control contents = super.createContents((Composite)scrolled);
        scrolled.setContent(contents);
        scrolled.setMinSize(contents.computeSize(-1, -1));
        FontReflowUtil.installListeners(scrolled);
        return scrolled;
    }

    public static class Result {
        private int fImportSelection;

        public void setImportSelection(int importSelection) {
            this.fImportSelection = importSelection;
        }

        public int getImportSelection() {
            return this.fImportSelection;
        }
    }

    private class WidgetListener
    implements SelectionListener,
    FocusListener {
        private WidgetListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == StackPatternImportDialog.this.fImportFromCurrentThreadButton) {
                StackPatternImportDialog.this.handleImportFromCurrentThreadButtonSelected();
            } else if (source == StackPatternImportDialog.this.fImportFromStackTraceButton) {
                StackPatternImportDialog.this.handleImportFromStackTraceButtonSelected();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void focusGained(FocusEvent e) {
            Object source = e.getSource();
            if (source == StackPatternImportDialog.this.fStackTraceText && StackPatternImportDialog.this.fHasInitialText) {
                StackPatternImportDialog.this.fHasInitialText = false;
                StackPatternImportDialog.this.fStackTraceText.setForeground(StackPatternImportDialog.this.getShell().getDisplay().getSystemColor(2));
                StackPatternImportDialog.this.fStackTraceText.setText("");
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }
}

