/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.breakpoints.stackpattern.internal.ui;

import com.ibm.debug.breakpoints.stackpattern.IStackPatternEntry;
import com.ibm.debug.breakpoints.stackpattern.IStackPatternLanguageAdapter;
import com.ibm.debug.breakpoints.stackpattern.StackPatternRoot;
import com.ibm.debug.breakpoints.stackpattern.StackPatternUtils;
import com.ibm.debug.breakpoints.stackpattern.ui.StackPatternPropertiesPage;
import com.ibm.debug.xmlui.api.XUIAttribute;
import com.ibm.debug.xmlui.api.XUIAttributeList;
import com.ibm.debug.xmlui.api.XUIModel;
import com.ibm.debug.xmlui.api.XUIParseException;
import com.ibm.debug.xmlui.ui.XUIReconciler;
import java.util.HashMap;
import org.eclipse.debug.core.model.IBreakpoint;

public class SPUIReconciler
extends XUIReconciler {
    private StackPatternPropertiesPage fPropertyPage;
    private HashMap<IBreakpoint, StackPatternRoot> fBreakpointPatternMap = new HashMap();

    public SPUIReconciler(XUIModel root) {
        super(root);
    }

    public void setPropertyPage(StackPatternPropertiesPage propertyPage) {
        this.fPropertyPage = propertyPage;
    }

    public void dispose() {
        this.fBreakpointPatternMap.clear();
        super.dispose();
    }

    private StackPatternRoot getBreakpointStackPattern(IBreakpoint breakpoint) {
        StackPatternRoot root = this.fBreakpointPatternMap.get(breakpoint);
        try {
            IStackPatternLanguageAdapter adapter;
            if (root == null && (adapter = StackPatternUtils.getLanguageAdapter(breakpoint)) != null && (root = adapter.parseStackPattern(breakpoint)) != null) {
                root.setLanguageAdapter(this.fPropertyPage.getLanguageAdapter());
                this.fBreakpointPatternMap.put(breakpoint, root);
            }
        }
        catch (XUIParseException ex) {
            StackPatternUtils.logError((Exception)((Object)ex));
        }
        return root;
    }

    public void reconcileBreakpointStackPatterns(IBreakpoint breakpoint) {
        StackPatternRoot root = this.getBreakpointStackPattern(breakpoint);
        if (root == null) {
            return;
        }
        this.fPropertyPage.createInitialStackPatternList(root);
        IStackPatternEntry[] patterns = root.getStackPatternEntries();
        if (patterns.length > 0) {
            this.reconcilePatternEntry(patterns[0]);
            this.setEnabledAllControls(false);
        }
    }

    public void reconcileStackPattern(IBreakpoint breakpoint, int index) {
        StackPatternRoot root = this.getBreakpointStackPattern(breakpoint);
        if (root == null) {
            return;
        }
        IStackPatternEntry[] patterns = root.getStackPatternEntries();
        if (index >= 0 && index < patterns.length) {
            IStackPatternEntry pattern = patterns[0];
            this.reconcilePatternEntry(pattern);
        }
    }

    public void reconcilePatternEntry(IStackPatternEntry patternEntry) {
        XUIAttributeList attributes = patternEntry.getAttributes();
        this.initializeDefaults();
        int i = 0;
        while (i < attributes.size()) {
            XUIAttribute attribute = attributes.getAttribute(i);
            this.reconcileAttribute(attribute);
            ++i;
        }
    }
}

