/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.breakpoints.stackpattern;

import com.ibm.debug.breakpoints.stackpattern.IStackPatternLanguageAdapter;
import com.ibm.debug.breakpoints.stackpattern.StackPatternRoot;
import com.ibm.debug.breakpoints.stackpattern.internal.Activator;
import com.ibm.debug.breakpoints.stackpattern.internal.parser.StackPatternParser;
import com.ibm.debug.xmlui.api.XUIParseException;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class StackPatternUtils {
    private static HashMap<String, IStackPatternLanguageAdapter> languageAdapters = null;

    public static Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public static void openErrorDialog(final CoreException e) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ErrorDialog.openError((Shell)new Shell(Display.getDefault()), (String)"Stack Pattern Error", (String)e.getMessage(), (IStatus)e.getStatus());
            }
        });
    }

    public static void setBreakpointAttribute(IBreakpoint breakpoint, String attribute, String value) {
        IMarker marker = breakpoint.getMarker();
        try {
            marker.setAttribute(attribute, (Object)value);
        }
        catch (CoreException e) {
            StackPatternUtils.openErrorDialog(e);
        }
    }

    public static void setBreakpointAttribute(IBreakpoint breakpoint, String attribute, boolean value) {
        IMarker marker = breakpoint.getMarker();
        try {
            marker.setAttribute(attribute, value);
        }
        catch (CoreException e) {
            StackPatternUtils.openErrorDialog(e);
        }
    }

    public static void setStackPatternEnabled(IBreakpoint breakpoint, boolean val) {
        StackPatternUtils.setBreakpointAttribute(breakpoint, "stack_pattern_enabled", val);
    }

    public static void setStackPatternAttribute(IBreakpoint breakpoint, String pattern) {
        StackPatternUtils.setBreakpointAttribute(breakpoint, "com.ibm.debug.breakpoints.stackpattern", pattern);
    }

    public static String getStackPatternAttribute(IBreakpoint breakpoint) {
        return StackPatternUtils.getBreakpointAttributeString(breakpoint, "com.ibm.debug.breakpoints.stackpattern");
    }

    public static Object getBreakpointAttribute(IBreakpoint breakpoint, String attribute) {
        Object val = null;
        try {
            val = breakpoint.getMarker().getAttribute(attribute);
        }
        catch (CoreException e) {
            StackPatternUtils.openErrorDialog(e);
        }
        return val;
    }

    public static boolean getBreakpointAttributeBoolean(IBreakpoint breakpoint, String attribute) {
        return breakpoint.getMarker().getAttribute(attribute, false);
    }

    public static String getBreakpointAttributeString(IBreakpoint breakpoint, String attribute) {
        return breakpoint.getMarker().getAttribute(attribute, "");
    }

    public static boolean isStackPatternEnabled(IBreakpoint breakpoint) {
        return StackPatternUtils.getBreakpointAttributeBoolean(breakpoint, "stack_pattern_enabled");
    }

    public static void logError(Exception e) {
        if (Activator.isLogging()) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = "";
            }
            Status sts = new Status(1, "com.ibm.debug.breakpoints.stackpattern", 0, msg, (Throwable)e);
            Activator.getLogFile().log((IStatus)sts);
            System.out.println();
        }
    }

    public static StackPatternRoot parseStackPattern(IBreakpoint breakpoint) throws XUIParseException {
        IStackPatternLanguageAdapter adapter = StackPatternUtils.getLanguageAdapter(breakpoint);
        String stackPattern = adapter.getStackPatternAttribute(breakpoint);
        if (stackPattern != null && stackPattern.length() > 0) {
            try {
                byte[] bytes = stackPattern.getBytes("UTF-8");
                ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
                StackPatternParser parser = new StackPatternParser();
                return parser.parse(byteStream);
            }
            catch (UnsupportedEncodingException ex) {
                throw new XUIParseException((Throwable)ex);
            }
        }
        return null;
    }

    public static ISourceLookupDirector getSourceLookupDirector(IStackFrame frame) {
        IDebugTarget debugTarget = frame.getThread().getDebugTarget();
        ISourceLocator sourceLocator = debugTarget.getLaunch().getSourceLocator();
        if (sourceLocator instanceof ISourceLookupDirector) {
            return (ISourceLookupDirector)sourceLocator;
        }
        return null;
    }

    public static IProject findProjectForStackFrame(IStackFrame frame) {
        ISourceLookupDirector director = StackPatternUtils.getSourceLookupDirector(frame);
        try {
            Object firstElement;
            Object[] elements = director.findSourceElements((Object)frame);
            if (elements.length > 0 && (firstElement = elements[0]) instanceof IResource) {
                return ((IResource)firstElement).getProject();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public static boolean sourceExists(IStackFrame frame) {
        ISourceLookupDirector director = StackPatternUtils.getSourceLookupDirector(frame);
        try {
            Object firstElement;
            Object[] elements = director.findSourceElements((Object)frame);
            if (elements.length > 0 && (firstElement = elements[0]) instanceof IResource) {
                return ((IResource)firstElement).exists();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    public static IConfigurationElement[] getExtensions(String extensionName) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.debug.breakpoints.stackpattern", extensionName);
        if (extensionPoint != null) {
            return extensionPoint.getConfigurationElements();
        }
        return null;
    }

    public static synchronized HashMap<String, IStackPatternLanguageAdapter> getLanguageAdapters() {
        if (languageAdapters != null) {
            return languageAdapters;
        }
        languageAdapters = new HashMap();
        IConfigurationElement[] configs = StackPatternUtils.getExtensions("languageAdapters");
        if (configs != null) {
            int i = 0;
            while (i < configs.length) {
                try {
                    IConfigurationElement config = configs[i];
                    IStackPatternLanguageAdapter adapter = (IStackPatternLanguageAdapter)config.createExecutableExtension("class");
                    String model = config.getAttribute("model");
                    if (model != null) {
                        adapter.setModel(model);
                        languageAdapters.put(model, adapter);
                    }
                }
                catch (CoreException ce) {
                    StackPatternUtils.logError((Exception)((Object)ce));
                }
                ++i;
            }
        }
        return languageAdapters;
    }

    public static IStackPatternLanguageAdapter getLanguageAdapter(IBreakpoint breakpoint) {
        HashMap<String, IStackPatternLanguageAdapter> adapters = StackPatternUtils.getLanguageAdapters();
        String modelId = breakpoint.getModelIdentifier();
        if (modelId != null) {
            return adapters.get(modelId);
        }
        return null;
    }

    public static String getStackPatternXMLString(StackPatternRoot root) {
        String patternString = root.toString();
        if (patternString.length() > 0) {
            String xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<stack_patterns>\n" + patternString + "</stack_patterns>";
            return xmlString;
        }
        return "";
    }
}

