/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.check.eclipse.running;

import com.ibm.check.eclipse.running.Messages;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.common.core.api.utils.EclipseUtil;
import com.ibm.cic.common.core.model.ISelectionExpression;
import java.io.File;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CheckEclipseRunningSelector
implements ISelectionExpression {
    private static final String PLUGIN_ID = "com.ibm.check.eclipse.running";

    public IStatus evaluate(ISelectionExpression.EvaluationContext context) {
        IProfile profile = this.getProfile(context);
        if (profile != null) {
            String configLocation;
            String kind = profile.getProfileKind();
            if ("existingEclipse".equals(kind)) {
                String contextId = profile.getData("eclipseContext");
                String configLocation2 = profile.getPropertyFromInstallContext(contextId, "configLocation");
                if (configLocation2 != null) {
                    File configDir = new File(configLocation2);
                    if (EclipseUtil.isEclipseRunning((File)configDir)) {
                        return new Status(4, PLUGIN_ID, 0, Messages.Eclipse_Is_Running, null);
                    }
                    return Status.OK_STATUS;
                }
            } else if ("product".equals(kind) && (configLocation = profile.getPropertyFromInstallContext("com.ibm.sdp.eclipse.ide", "configLocation")) != null) {
                File configDir = new File(configLocation);
                if (EclipseUtil.isEclipseRunning((File)configDir)) {
                    return new Status(4, PLUGIN_ID, 0, Messages.Eclipse_Is_Running, null);
                }
                return Status.OK_STATUS;
            }
        }
        return Status.OK_STATUS;
    }

    private IProfile getProfile(ISelectionExpression.EvaluationContext context) {
        if (!(context instanceof IAdaptable)) {
            return null;
        }
        IAdaptable adaptable = (IAdaptable)context;
        Object adapter = adaptable.getAdapter(IProfile.class);
        if (!(adapter instanceof IProfile)) {
            return null;
        }
        return (IProfile)adapter;
    }
}

