/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.state.parsers;

import com.ibm.ut.help.state.parsers.ParseElement;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SiteXMLParser
extends DefaultHandler {
    private Properties properties;
    private ArrayList categories = new ArrayList();
    private ArrayList features = new ArrayList();
    private String sitexml;
    private String featureIDsAndVersions = "";

    public IStatus parse(String sitexml) {
        this.sitexml = sitexml;
        try {
            URL url = new URL(sitexml);
            this.parse(url.openStream());
        }
        catch (Exception ex) {
            return new Status(4, "com.ibm.ut.help.state", "Unable to parse site.", (Throwable)ex);
        }
        return new Status(0, "com.ibm.ut.help.state", "");
    }

    public static String getUnicodeString(String s, String charsetName) throws UnsupportedEncodingException {
        return new String(s.getBytes("8859_1"), charsetName);
    }

    public IStatus parse(InputStream in) {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(in, (DefaultHandler)this);
        }
        catch (Exception ex) {
            return new Status(4, "com.ibm.ut.help.state", "Unable to parse site.", (Throwable)ex);
        }
        return new Status(0, "com.ibm.ut.help.state", "");
    }

    @Override
    public void startElement(String uri, String lname, String name, Attributes attrs) {
        if (name.equalsIgnoreCase("feature")) {
            this.properties = new Properties();
            this.properties.setProperty("url", attrs.getValue("url"));
            this.properties.setProperty("id", attrs.getValue("id"));
            this.addFeatureID(attrs.getValue("id") + "_");
            this.properties.setProperty("version", attrs.getValue("version"));
            this.addVersion(attrs.getValue("version"));
        } else if (name.equalsIgnoreCase("category")) {
            this.properties.setProperty("category_name", attrs.getValue("name"));
        } else if (name.equalsIgnoreCase("category-def")) {
            Properties props = new Properties();
            props.setProperty("name", attrs.getValue("name"));
            props.setProperty("label", attrs.getValue("label"));
            props.setProperty("title", attrs.getValue("label"));
            props.setProperty("type", "category");
            ParseElement elem = new ParseElement(name, props);
            this.categories.add(elem);
        }
    }

    @Override
    public void endElement(String uri, String lname, String name) {
        if (name.equalsIgnoreCase("feature")) {
            ParseElement elem = new ParseElement(name, this.properties);
            this.features.add(elem);
            this.properties = null;
        }
    }

    public ArrayList getCategories() {
        return this.categories;
    }

    public ArrayList getFeatures() {
        return this.features;
    }

    public ArrayList getFeaturesByCategory(String categoryName) {
        ArrayList<ParseElement> list = new ArrayList<ParseElement>();
        int i = 0;
        while (i < this.features.size()) {
            ParseElement elem = (ParseElement)this.features.get(i);
            if (elem.getProperty("category_name") != null && elem.getProperty("category_name").equals(categoryName)) {
                list.add(elem);
            }
            ++i;
        }
        return list;
    }

    public void addFeatureID(String featureID) {
        this.featureIDsAndVersions = this.featureIDsAndVersions + featureID;
    }

    public void addVersion(String version) {
        this.featureIDsAndVersions = this.featureIDsAndVersions + version + ",";
    }

    public String getFeatureIDsAndVersions() {
        return this.featureIDsAndVersions;
    }

    public String toString() {
        return this.sitexml + " " + String.valueOf(this.getCategories());
    }
}

