/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.state.parsers;

import com.ibm.ut.help.state.parsers.ProductItems;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FeedParser
extends DefaultHandler {
    private ArrayList items = new ArrayList();
    private String feedurl;
    private Properties properties;
    private String currentTag;

    public void parse(URL feedURL) throws ParserConfigurationException, SAXException, IOException {
        this.parse(feedURL.openStream());
    }

    public void parse(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        parser.parse(in, (DefaultHandler)this);
    }

    @Override
    public void startElement(String uri, String lname, String name, Attributes attrs) {
        this.currentTag = name;
        if (name.equalsIgnoreCase("item")) {
            this.properties = new Properties();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        String content = new String(ch, start, length);
        if (this.properties != null) {
            String existing = (String)this.properties.get(this.currentTag);
            if (existing == null) {
                existing = "";
            }
            content = content.replaceAll("[\\n\\t]", "");
            this.properties.put(this.currentTag, existing + content);
        }
    }

    @Override
    public void endElement(String uri, String lname, String name) {
        if (name.equalsIgnoreCase("item")) {
            String title = this.properties.getProperty("title");
            String version = this.properties.getProperty("version");
            this.properties.setProperty("type", "site");
            ProductItems element = null;
            int i = 0;
            while (i < this.items.size()) {
                ProductItems item = (ProductItems)this.items.get(i);
                if (item.getName().equalsIgnoreCase(title)) {
                    element = item;
                    break;
                }
                ++i;
            }
            if (element == null) {
                Properties props = new Properties();
                props.setProperty("title", title);
                props.setProperty("type", "publicsite");
                element = new ProductItems(title, props);
                this.items.add(element);
            }
            element.setProperty(version, this.properties);
            this.properties = null;
        }
    }

    public ArrayList getItems() {
        return this.items;
    }

    public String toString() {
        return this.feedurl + " " + String.valueOf(this.getItems());
    }
}

