/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.profile.internal.model;

import com.ibm.debug.pdt.profile.IIMSIsoDebugProfile;
import com.ibm.debug.pdt.profile.IIMSRoutingInfo;
import com.ibm.debug.pdt.profile.IIMSTransaction;
import com.ibm.debug.pdt.profile.internal.ims.IIMSIsolationAPIProvider;
import com.ibm.debug.pdt.profile.internal.ims.IMSIsolationProfileUtils;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTSP;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DebugProfileIMS
extends DebugProfileDTSP
implements IIMSIsoDebugProfile {
    protected ArrayList<Transaction> fTransactions;
    protected ArrayList<String> fSTEPLIB;
    protected String fIMSID;
    protected String fIMSJobName;
    protected String fIMSJobClass;

    public DebugProfileIMS(String name) {
        super(name);
        this.fType = "IMS";
        this.fTransactions = new ArrayList();
    }

    public Transaction[] getTransactions() {
        return this.fTransactions.toArray(new Transaction[this.fTransactions.size()]);
    }

    @Override
    public void addTransaction(IIMSTransaction t) {
        if (t instanceof Transaction) {
            this.fTransactions.add((Transaction)t);
        }
    }

    public void clearTransactions() {
        this.fTransactions.clear();
    }

    @Override
    public void setIMSID(String id) {
        this.fIMSID = id;
    }

    public String getIMSID() {
        return this.fIMSID;
    }

    @Override
    public void setIMSJobName(String jobName) {
        this.fIMSJobName = jobName;
    }

    public String getIMSJobName() {
        return this.fIMSJobName;
    }

    @Override
    public void setJobClass(String jobclass) {
        this.fIMSJobClass = jobclass;
    }

    public String getJobClass() {
        return this.fIMSJobClass;
    }

    @Override
    public void setSTEPLIB(String[] stepLibs) {
        if (stepLibs.length > 0) {
            this.fSTEPLIB = new ArrayList<String>(Arrays.asList(stepLibs));
        }
    }

    public String[] getSTEPLIB() {
        return this.fSTEPLIB == null ? null : this.fSTEPLIB.toArray(new String[this.fSTEPLIB.size()]);
    }

    @Override
    protected boolean checkForGenericProfile() {
        return true;
    }

    @Override
    public void activate(int mode) throws Exception {
        block21: {
            Exception dtspException = null;
            IIMSIsolationAPIProvider provider = IMSIsolationProfileUtils.getIMSIsolationAPIProvider();
            if (provider != null) {
                provider.stopRegion(this);
            }
            try {
                try {
                    super.activate(mode);
                }
                catch (Exception e) {
                    dtspException = e;
                    if (this.isValid() && provider != null) {
                        try {
                            provider.activate(this, mode);
                        }
                        catch (Exception e2) {
                            super.deactivate();
                            this.resetStateUnknown();
                            Object message = e2.getMessage();
                            if (dtspException != null && dtspException.getMessage() != null && !dtspException.getMessage().isEmpty()) {
                                message = dtspException.getMessage() + "\n" + (String)message;
                            }
                            throw new DebugProfileException((String)message);
                        }
                    }
                    if (dtspException != null) {
                        throw dtspException;
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (this.isValid() && provider != null) {
                    try {
                        provider.activate(this, mode);
                    }
                    catch (Exception e) {
                        super.deactivate();
                        this.resetStateUnknown();
                        Object message = e.getMessage();
                        if (dtspException != null && dtspException.getMessage() != null && !dtspException.getMessage().isEmpty()) {
                            message = dtspException.getMessage() + "\n" + (String)message;
                        }
                        throw new DebugProfileException((String)message);
                    }
                }
                if (dtspException != null) {
                    throw dtspException;
                }
                throw throwable;
            }
            if (this.isValid() && provider != null) {
                try {
                    provider.activate(this, mode);
                }
                catch (Exception e) {
                    super.deactivate();
                    this.resetStateUnknown();
                    Object message = e.getMessage();
                    if (dtspException != null && dtspException.getMessage() != null && !dtspException.getMessage().isEmpty()) {
                        message = dtspException.getMessage() + "\n" + (String)message;
                    }
                    throw new DebugProfileException((String)message);
                }
            }
            if (dtspException != null) {
                throw dtspException;
            }
        }
        super.sendActivationEvent();
    }

    @Override
    public void deactivate() throws Exception {
        IIMSIsolationAPIProvider provider;
        if (this.isValid() && this.fState == 1 && (provider = IMSIsolationProfileUtils.getIMSIsolationAPIProvider()) != null) {
            try {
                provider.deactivate(this);
            }
            catch (Exception e) {
                Object message;
                block5: {
                    this.resetStateUnknown();
                    message = e.getMessage();
                    try {
                        super.deactivate();
                    }
                    catch (Exception dtspException) {
                        if (dtspException.getMessage() == null || dtspException.getMessage().isEmpty()) break block5;
                        message = dtspException.getMessage() + "\n" + (String)message;
                    }
                }
                throw new DebugProfileException((String)message);
            }
        }
        super.deactivate();
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.fIMSID != null && !this.fIMSID.isEmpty() && this.fTransactions.size() > 0;
    }

    @Override
    protected List<String> getProfileIssues() {
        List<String> issues = super.getProfileIssues();
        if (!this.doValidateProfile()) {
            if (this.fIMSID == null || this.fIMSID.isEmpty()) {
                issues.add(IMSIsolationProfileUtils.getIMSIsolationAPIProvider().getIMSIDMissingMessage());
            }
            if (this.fTransactions.isEmpty()) {
                issues.add(IMSIsolationProfileUtils.getIMSIsolationAPIProvider().getMissingTransactionMessage());
            }
        }
        return issues;
    }

    @Override
    protected boolean doValidateProfile() {
        return super.doValidateProfile() && this.fIMSID != null && !this.fIMSID.isEmpty() && this.fTransactions.size() > 0;
    }

    @Override
    public void delete() throws Exception {
        boolean isActive = this.getState() == 1;
        try {
            super.delete();
        }
        finally {
            IIMSIsolationAPIProvider provider;
            if (isActive && (provider = IMSIsolationProfileUtils.getIMSIsolationAPIProvider()) != null) {
                try {
                    provider.deactivate(this);
                }
                catch (Exception e) {
                    throw new DebugProfileException(e.getMessage());
                }
            }
        }
    }

    @Override
    protected void sendActivationEvent() {
    }

    public void activateDTSPDebug() throws Exception {
        super.activate(1);
        this.fMode = 0;
        this.fState = 0;
    }

    public static class RoutingInfo
    implements IIMSRoutingInfo {
        protected boolean fPmCase;
        protected boolean fPmHex;
        protected String fPmMessage;
        protected Integer fPmRangeStart;
        protected Integer fPmRangeLength;

        public RoutingInfo(boolean pmCase, boolean pmHex, String pmMessage, Integer pmRangeStart, Integer pmRangeLength) {
            this.fPmCase = pmCase;
            this.fPmHex = pmHex;
            this.fPmMessage = pmMessage;
            this.fPmRangeStart = pmRangeStart;
            this.fPmRangeLength = pmRangeLength;
        }

        public boolean isCaseSensitive() {
            return this.fPmCase;
        }

        public boolean isHex() {
            return this.fPmHex;
        }

        public String getPatternMessage() {
            return this.fPmMessage;
        }

        public Integer getRangeStartMessage() {
            return this.fPmRangeStart;
        }

        public Integer getRangeLengthMessage() {
            return this.fPmRangeLength;
        }
    }

    public static class Transaction
    implements IIMSTransaction {
        protected String fName;
        protected String fPsbName;
        protected boolean fRegistered;
        protected RoutingInfo fRoutingInfo;

        public Transaction(String name, String psbName, boolean registered) {
            this.fName = name;
            this.fPsbName = psbName;
            this.fRegistered = registered;
        }

        public boolean isRegistered() {
            return this.fRegistered;
        }

        @Override
        public void setRoutingInfo(IIMSRoutingInfo info) {
            if (info instanceof RoutingInfo) {
                this.fRoutingInfo = (RoutingInfo)info;
            }
        }

        public String getName() {
            return this.fName;
        }

        public String getPbsName() {
            return this.fPsbName;
        }

        public RoutingInfo getRoutingInfo() {
            return this.fRoutingInfo;
        }
    }
}

