/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.profile.internal.connection;

import com.ibm.debug.pdt.profile.internal.LogUtils;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.connection.IConnectionInfo;
import com.ibm.debug.pdt.profile.internal.connection.IConnectionProvider;
import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class ConnectionUtilities
implements IDebugProfileConstants {
    private static final String UPPERCASE_LETTERS = "[a-z]";
    private static final IConnectionProvider fProvider = ConnectionUtilities.getConnectionProvider();
    private static final Map<String, Connection> fConnections = Collections.synchronizedMap(new HashMap());

    private static IConnectionProvider getConnectionProvider() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.debug.pdt.profile.eclipse.connectionProvider");
        if (extensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray = extensionPoint.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement config = iConfigurationElementArray[n2];
                try {
                    return (IConnectionProvider)config.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    LogUtils.log(e);
                }
                catch (ClassCastException e) {
                    LogUtils.log(e);
                }
                ++n2;
            }
        }
        return null;
    }

    public static Connection getConnection(String connectionName, boolean forceConnect) {
        Connection c = ConnectionUtilities.getConnection(connectionName);
        if (fProvider != null) {
            if (c != null) {
                if (forceConnect) {
                    return fProvider.connect(c);
                }
            } else {
                IConnectionInfo info = fProvider.getConnectionInfo(connectionName, forceConnect);
                if (info != null) {
                    c = new Connection(info);
                    ConnectionUtilities.addConnection(c);
                }
            }
        }
        return c;
    }

    public static String uppercaseUserID(String user) {
        StringBuilder sb = new StringBuilder(user == null ? "" : user);
        int i = 0;
        while (i < sb.length()) {
            if (String.valueOf(sb.charAt(i)).matches(UPPERCASE_LETTERS)) {
                sb.replace(i, i + 1, ("" + sb.charAt(i)).toUpperCase(Locale.getDefault()));
            }
            ++i;
        }
        return sb.toString();
    }

    public static Connection getConnection(String connectionName) {
        return fConnections.get(connectionName);
    }

    public static Collection<Connection> getConnections() {
        return fConnections.values();
    }

    private static void addConnection(Connection c) {
        fConnections.put(c.getConnectionName(), c);
    }

    public static Connection getConnection(IConnectionInfo info) {
        if (info == null) {
            return null;
        }
        Connection connection = ConnectionUtilities.getConnection(info.getConnectionName());
        if (connection == null) {
            connection = new Connection(info);
            ConnectionUtilities.addConnection(connection);
        }
        return connection;
    }

    public static void removeConnection(Connection c) {
        ConnectionUtilities.removeConnection(c.getConnectionName());
    }

    public static void removeConnection(String connectionName) {
        fConnections.remove(connectionName);
    }

    public static boolean hasDisconnectedConnection() {
        boolean result = false;
        for (Connection conn : ConnectionUtilities.getConnections()) {
            boolean bl = result = !conn.isConnected();
            if (result) break;
        }
        return result;
    }

    public static boolean hasConnectionAvailable() {
        return !ConnectionUtilities.getConnections().isEmpty();
    }
}

