/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.profile.internal.configuration;

import com.ibm.debug.pdt.profile.internal.LogUtils;
import com.ibm.debug.pdt.profile.internal.configuration.IDebugProfileExtendedSupport;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509TrustManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class ExtendedSupportUtillities {
    private static final IDebugProfileExtendedSupport fProvider = ExtendedSupportUtillities.getSupportProvider();

    private static IDebugProfileExtendedSupport getSupportProvider() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.debug.pdt.profile.eclipse.extendedProfileSupport");
        if (extensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray = extensionPoint.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement config = iConfigurationElementArray[n2];
                try {
                    return (IDebugProfileExtendedSupport)config.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    LogUtils.log(e);
                }
                catch (ClassCastException e) {
                    LogUtils.log(e);
                }
                ++n2;
            }
        }
        return null;
    }

    public static X509TrustManager getTrustManager() {
        if (fProvider != null) {
            return fProvider.getTrustManager();
        }
        return null;
    }

    public static boolean handleSSLException(SSLException hse, X509TrustManager trustManager, Connection connection) {
        if (fProvider != null) {
            return fProvider.handleSSLException(hse, trustManager, connection);
        }
        return false;
    }

    public static boolean isNonSecuredAllowed(Connection connection) {
        if (fProvider != null) {
            return fProvider.isNonSecuredAllowed(connection);
        }
        return false;
    }

    public static boolean isDarkTheme() {
        if (fProvider != null) {
            return fProvider.isDarkTheme();
        }
        return false;
    }

    public static boolean enableSecuredDebugDaemon() {
        if (fProvider != null) {
            return fProvider.enableSecuredDebugDaemon();
        }
        return false;
    }

    public static int getDaemonPort(boolean profileMode) {
        if (fProvider != null) {
            return fProvider.getDaemonPort(profileMode);
        }
        return -1;
    }

    public static boolean checkForGenericDTSPProfile(boolean isJobNameGeneric, boolean isStepNameGeneric, boolean isSubsystemNameGeneric, boolean isTransactionGeneric, boolean isGenericLoadModulePairs) {
        if (fProvider != null) {
            return fProvider.checkForGenericDTSPProfile(isJobNameGeneric, isStepNameGeneric, isSubsystemNameGeneric, isTransactionGeneric, isGenericLoadModulePairs);
        }
        return true;
    }

    public static boolean checkForDTCNGenericProfile(boolean isUserIDGeneric, boolean isTransactionGeneric, boolean isIPGeneric, boolean isTerminalGeneric, boolean isLoadModuleProgramGeneric) {
        if (fProvider != null) {
            return fProvider.checkForDTCNGenericProfile(isUserIDGeneric, isTransactionGeneric, isIPGeneric, isTerminalGeneric, isLoadModuleProgramGeneric);
        }
        return true;
    }

    public static void profileRootStartup() {
        if (fProvider != null) {
            fProvider.profileRootStartup();
        }
    }
}

