/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.profile;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.ibm.debug.pdt.profile.IAdditionalCICSFilters;
import com.ibm.debug.pdt.profile.ICICSDebugProfile;
import com.ibm.debug.pdt.profile.IDebugProfile;
import com.ibm.debug.pdt.profile.IIMSIsoDebugProfile;
import com.ibm.debug.pdt.profile.IIMSRoutingInfo;
import com.ibm.debug.pdt.profile.IIMSTransaction;
import com.ibm.debug.pdt.profile.INonCICSDebugProfile;
import com.ibm.debug.pdt.profile.ProfileException;
import com.ibm.debug.pdt.profile.internal.ProfileMessages;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionUtilities;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTCN;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTSP;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileException;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileIMS;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileNameUtils;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileRoot;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileUtils;
import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import com.ibm.debug.pdt.profile.internal.model.ProfileLevels;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.osgi.util.NLS;

public final class DebugProfileFactory {
    private static final DebugProfileFactory fInstance = new DebugProfileFactory();

    public static DebugProfileFactory getInstance() {
        return fInstance;
    }

    private DebugProfileFactory() {
    }

    public ICICSDebugProfile createCICSDebugProfile(String rseConnectionName) throws ProfileException {
        return this.createCICSDebugProfile(rseConnectionName, true);
    }

    private ICICSDebugProfile createCICSDebugProfile(String rseConnectionName, boolean isTemporary) throws ProfileException {
        try {
            this.checkConnection(rseConnectionName, true);
        }
        catch (OperationCanceledException e) {
            return null;
        }
        DebugProfileDTCN profile = new DebugProfileDTCN(DebugProfileNameUtils.generateNewName("CICS-PROFILE-"));
        profile.setConnectionName(rseConnectionName);
        profile.setAdditionalCICSFilters(new DebugProfileDTCN.AdditionalCICSFilters("&USERID", null, null, null, null));
        profile.setDebuggerOptions(new DebugProfile.DebuggerOptions(IDebugProfileConstants.TEST_LEVEL_DEFAULT, IDebugProfileConstants.ERROR_LEVEL_DEFAULT_CICS, IDebugProfileConstants.PROMPT_LEVEL_DEFAULT));
        if (!isTemporary) {
            DebugProfileRoot.getInstance().addDebugProfile(profile);
        }
        return profile;
    }

    public INonCICSDebugProfile createNonCICSDebugProfile(String rseConnectionName) throws ProfileException {
        return this.createNonCICSDebugProfile(rseConnectionName, true);
    }

    private INonCICSDebugProfile createNonCICSDebugProfile(String rseConnectionName, boolean isTemporary) throws ProfileException {
        try {
            this.checkConnection(rseConnectionName, false);
        }
        catch (OperationCanceledException e) {
            return null;
        }
        DebugProfileDTSP profile = new DebugProfileDTSP(DebugProfileNameUtils.generateNewName("PROFILE-"));
        profile.setDebuggerOptions(new DebugProfile.DebuggerOptions(IDebugProfileConstants.TEST_LEVEL_DEFAULT, ProfileLevels.getErrorLevels()[1], IDebugProfileConstants.PROMPT_LEVEL_DEFAULT));
        profile.setConnectionName(rseConnectionName);
        if (!isTemporary) {
            DebugProfileRoot.getInstance().addDebugProfile(profile);
        }
        return profile;
    }

    public void checkConnection(String rseConnectionName, boolean checkCICS) throws ProfileException {
        this.checkConnection(rseConnectionName, checkCICS, false);
    }

    public void checkConnection(String rseConnectionName, boolean checkCICS, boolean checkIMSIso) throws ProfileException {
        Connection connection;
        if (checkIMSIso) {
            checkCICS = false;
        }
        if ((connection = DebugProfileFactory.getConnection(rseConnectionName)).getErrorState() == Connection.ERROR_STATE.NOT_CONNECTED) {
            if (checkCICS && !checkIMSIso) {
                connection.getCICSRegionAndPorts();
                if (connection.getCICSException() != null) {
                    throw new DebugProfileException(connection.getCICSException());
                }
            } else {
                connection.getNonCICSLocation();
                if (connection.getNonCICSException() != null) {
                    throw new DebugProfileException(connection.getNonCICSException());
                }
                if (checkIMSIso) {
                    connection.checkIMSIsoConnection();
                }
            }
        }
        if (!connection.isRecordingPlaybackSupported()) {
            throw new ProfileException(NLS.bind((String)ProfileMessages.CRRDG9172, (Object[])new Object[]{1.5, connection.getAPIVersion()}));
        }
        switch (connection.getErrorState()) {
            case BACK_LEVEL: 
            case CICS_ONLY: {
                throw new ProfileException(ProfileMessages.CRRDG9113);
            }
            case NOT_CONNECTED: {
                throw new OperationCanceledException();
            }
            case CLIENT_ERROR: 
            case HOST_ERROR: 
            case AUTHENTICATION_NOT_VALID: {
                throw new ProfileException(connection.getErrorMessage());
            }
        }
    }

    protected static Connection getConnection(String rseConnectionName) {
        Connection connection = ConnectionUtilities.getConnection(rseConnectionName, true);
        if (connection == null) {
            throw new OperationCanceledException();
        }
        return connection;
    }

    public static IAdditionalCICSFilters createAdditionalCICSFilter(String userID, String netName, String ip, String cicsSysID, String terminalID) {
        return new DebugProfileDTCN.AdditionalCICSFilters(userID, netName, ip, cicsSysID, terminalID);
    }

    public static IDebugProfile createProfileFromJSON(String json) throws JsonSyntaxException {
        JsonElement profileJson = JsonParser.parseString((String)json);
        if (profileJson.isJsonObject()) {
            return DebugProfileUtils.jsonToDebugProfile(profileJson.getAsJsonObject());
        }
        return null;
    }

    public IIMSIsoDebugProfile createIMSIsoDebugProfile(String rseConnectionName) throws ProfileException {
        return this.createIMSIsoDebugProfile(rseConnectionName, true);
    }

    private IIMSIsoDebugProfile createIMSIsoDebugProfile(String rseConnectionName, boolean isTemporary) throws ProfileException {
        try {
            this.checkConnection(rseConnectionName, false, true);
        }
        catch (OperationCanceledException e) {
            return null;
        }
        DebugProfileIMS profile = new DebugProfileIMS(DebugProfileNameUtils.generateNewName("IMS-PROFILE-"));
        profile.setDebuggerOptions(new DebugProfile.DebuggerOptions(IDebugProfileConstants.TEST_LEVEL_DEFAULT, ProfileLevels.getErrorLevels()[1], IDebugProfileConstants.PROMPT_LEVEL_DEFAULT));
        profile.setConnectionName(rseConnectionName);
        if (!isTemporary) {
            DebugProfileRoot.getInstance().addDebugProfile(profile);
        }
        return profile;
    }

    public IIMSTransaction createIMSTransaction(String name, String psbName, boolean registered) {
        return new DebugProfileIMS.Transaction(name, psbName, registered);
    }

    public IIMSRoutingInfo createIMSRoutingInfo(boolean isCaseSensitive, boolean isHex, String routingMessage, int rangeStart, int rangeLength) {
        return new DebugProfileIMS.RoutingInfo(isCaseSensitive, isHex, routingMessage, rangeStart, rangeLength);
    }
}

