/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.common;

import com.ibm.cic.licensing.common.IMessengerProvider;
import com.ibm.cic.licensing.common.Messages;
import com.ibm.cic.licensing.common.MessengerFactory;
import com.ibm.cic.licensing.common.core.LicenseChecker;
import com.ibm.cic.licensing.common.core.RegScanner;
import com.ibm.cic.licensing.common.util.LicUserUtils;
import com.ibm.cic.licensing.common.util.Logger;
import com.ibm.cic.licensing.common.util.ProductInformation;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class LicenseCheck
extends Plugin {
    private static LicenseCheck plugin;

    public LicenseCheck() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static LicenseCheck getDefault() {
        return plugin;
    }

    public static boolean requestLicense(Plugin aPlugin, String aComponentID, String aVersion, boolean quiet) throws CoreException {
        RegScanner.scan((String)"com.ibm.cic.licensing.common.licenseInformation");
        if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
            Logger.trace((String)(aPlugin.getBundle().getSymbolicName() + " called requestLicense for (" + aComponentID + ", " + aVersion + ")"));
        }
        IMessengerProvider messenger = MessengerFactory.getMessenger();
        boolean returnCode = false;
        switch (LicenseChecker.requestLicense((Plugin)aPlugin, (String)aComponentID, (String)aVersion, (boolean)quiet)) {
            case 0: {
                returnCode = true;
                break;
            }
            case 1: {
                String errmsg = LicenseChecker.getLastErrMsg();
                if (!quiet) {
                    LicenseCheck.displayWarningMsg(messenger, errmsg, 1);
                } else {
                    Logger.log((int)Logger.WARNING, (String)errmsg);
                }
                returnCode = true;
                break;
            }
            case 4: {
                String errmsg = LicenseChecker.getLastErrMsg();
                if (!quiet) {
                    LicenseCheck.displayWarningMsg(messenger, errmsg, 4);
                } else {
                    Logger.log((int)Logger.WARNING, (String)errmsg);
                }
                returnCode = true;
                break;
            }
            case 5: {
                String errmsg = LicenseChecker.getLastErrMsg();
                String pTitleOfDialog = Messages.Plugin_incompatibleServerVersionTitle;
                LicenseCheck.displayErrorAndExitWorkbench(messenger, pTitleOfDialog, Messages.Plugin_incompatibleServerVersionMessage);
                if (Logger.isTracing((boolean)Logger.DEBUG_METHODS)) {
                    Logger.log((int)Logger.ERROR, (String)Messages.Plugin_incompatibleServerVersionMessage);
                }
                returnCode = false;
                break;
            }
            default: {
                if (!quiet) {
                    String errmsg = LicenseChecker.getLastErrMsg();
                    Hashtable piErrors = LicenseChecker.getLastErrCondtion();
                    String aPluginID = LicUserUtils.getPluginID((Plugin)aPlugin, (String)aComponentID);
                    String aPluginName = LicUserUtils.getPluginName((Plugin)aPlugin, (String)aComponentID);
                    String detailErrorMsg = null;
                    if (piErrors.size() == 1) {
                        ProductInformation prodinfo = (ProductInformation)piErrors.keys().nextElement();
                        String errorCode = ((Exception)piErrors.get(prodinfo)).getLocalizedMessage();
                        detailErrorMsg = prodinfo.getProductName().equalsIgnoreCase("NILL") ? errorCode : NLS.bind((String)Messages.Plugin_No_License_Due_To, (Object)aPluginName, (Object)errorCode);
                        Status astatus = new Status(4, aPluginID, 0, detailErrorMsg, (Throwable)new Exception(detailErrorMsg));
                        messenger.displayError(errmsg, (IStatus)astatus, piErrors);
                        LicenseCheck.throwCoreException(aPluginID, null);
                    }
                    detailErrorMsg = NLS.bind((String)Messages.Enabled_By_Following, (Object)aPluginName);
                    MultiStatus mstatus = new MultiStatus(aPluginID, 4, detailErrorMsg, (Throwable)new Exception(detailErrorMsg));
                    Enumeration pikeys = piErrors.keys();
                    while (pikeys.hasMoreElements()) {
                        ProductInformation prodinfo = (ProductInformation)pikeys.nextElement();
                        Exception oex = (Exception)piErrors.get(prodinfo);
                        String offeringName = prodinfo.getProductName();
                        String childErrorMsg = offeringName + " : " + oex.getLocalizedMessage();
                        Status childStatus = new Status(4, aPluginID, 0, childErrorMsg, null);
                        mstatus.add((IStatus)childStatus);
                    }
                    messenger.displayError(errmsg, (IStatus)mstatus, piErrors);
                    LicenseCheck.throwCoreException(aPluginID, null);
                    break;
                }
                Logger.logNtrace((int)Logger.ERROR, (String)"LicenseCheck returned FALSE!");
                returnCode = false;
            }
        }
        return returnCode;
    }

    public static boolean requestLicense(Plugin aPlugin, String aComponentID, String aVersion) throws CoreException {
        return LicenseCheck.requestLicense(aPlugin, aComponentID, aVersion, false);
    }

    private static void displayWarningMsg(IMessengerProvider messenger, String errmsg, int licStatusCode) {
        try {
            if (errmsg != null && errmsg.trim().length() > 0) {
                Hashtable piErrors = LicenseChecker.getLastErrCondtion();
                Enumeration pikeys = piErrors.keys();
                while (pikeys.hasMoreElements()) {
                    ProductInformation pi = (ProductInformation)pikeys.nextElement();
                    if (pi.getLicenseStatus().getStatusCode() != licStatusCode) continue;
                    messenger.displayWarning(pi, errmsg);
                }
            }
        }
        catch (Exception e) {
            Logger.trace((String)("Failed to display warning message " + errmsg), (Exception)e);
        }
    }

    private static void displayErrorAndExitWorkbench(IMessengerProvider messenger, String pTitle, String pErrorMessage) {
        try {
            if (pErrorMessage != null && pErrorMessage.trim().length() > 0) {
                messenger.displayErrorAndExit(pTitle, pErrorMessage);
            }
        }
        catch (Exception e) {
            Logger.trace((String)("Failed to display error message " + pErrorMessage), (Exception)e);
        }
    }

    public static void throwCoreException(String aPluginID, Exception e) throws CoreException {
        String pluginID = aPluginID;
        String msg = NLS.bind((String)Messages.Plugin_No_License, (Object)pluginID);
        if (pluginID == null || pluginID.trim().length() < 1) {
            Bundle thisBundle = LicenseCheck.getDefault().getBundle();
            pluginID = thisBundle.getSymbolicName();
        }
        throw new CoreException((IStatus)new Status(1, pluginID, 0, msg, (Throwable)e));
    }

    public static boolean configureRCLLogging(String configFileLocation, String logFileLocation, String product, String version, int size, int logLevel, int traceLevel, int maxFiles, boolean enableLogging, boolean enableTracing) {
        return LicenseChecker.configureRCLLogging((String)configFileLocation, (String)logFileLocation, (String)product, (String)version, (int)size, (int)logLevel, (int)traceLevel, (int)maxFiles, (boolean)enableLogging, (boolean)enableTracing);
    }
}

