/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.common;

import com.ibm.debug.pdt.common.DebugImageDescriptor;
import com.ibm.debug.pdt.internal.common.CommonDebugPlugin;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class CommonUtils {
    private static ImageRegistry fgImageRegistry;
    private static HashMap<String, ImageDescriptor> fgImageDescriptors;
    private static Object fgImageRegistryInitLock;
    private static final String OBJECT = "obj16/";
    private static final String OVERLAY = "ovr16/";
    private static URL ICON_BASE_URL;
    private static final String EMPTY_STRING = "";

    static {
        fgImageRegistryInitLock = new Object();
        ICON_BASE_URL = CommonDebugPlugin.getPluginBundle().getEntry("icons/full/");
    }

    public static void logError(Exception e) {
        if (CommonDebugPlugin.logging) {
            String message = e.getMessage();
            if (message == null) {
                message = EMPTY_STRING;
            }
            Status sts = new Status(1, CommonDebugPlugin.getPluginID(), 0, message, (Throwable)e);
            CommonDebugPlugin.logFile.log((IStatus)sts);
        }
    }

    public static void logText(String text) {
        if (CommonDebugPlugin.logging) {
            Status sts = new Status(1, CommonDebugPlugin.getPluginID(), 0, text, null);
            CommonDebugPlugin.logFile.log((IStatus)sts);
        }
    }

    public static void logEvent(String text, Object originator) {
        if (CommonDebugPlugin.events) {
            String s = "EVENT(" + CommonUtils.getBaseName(originator) + ")-> " + text;
            Status sts = new Status(1, CommonDebugPlugin.getPluginID(), 0, s, null);
            CommonDebugPlugin.logFile.log((IStatus)sts);
        }
    }

    public static String getBaseName(Object obj) {
        if (obj == null) {
            return null;
        }
        String qualifiedClassName = obj.getClass().getName();
        return qualifiedClassName.substring(qualifiedClassName.lastIndexOf(".") + 1);
    }

    public static String getModelIdentifier() {
        return "com.ibm.debug.pdt.common";
    }

    public static ImageRegistry getImageRegistry() {
        if (fgImageRegistry == null) {
            CommonUtils.initializeImageRegistry();
        }
        return fgImageRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeImageRegistry() {
        Object object = fgImageRegistryInitLock;
        synchronized (object) {
            if (fgImageRegistry != null) {
                return;
            }
            fgImageRegistry = new ImageRegistry(PlatformUI.getWorkbench().getDisplay());
            fgImageDescriptors = new HashMap(30);
            CommonUtils.declareImages();
            CommonUtils.declareBreakpointImages();
        }
    }

    private static final void declareRegistryImage(String key, String path) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        try {
            desc = ImageDescriptor.createFromURL((URL)CommonUtils.makeIconFileURL(path));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        fgImageRegistry.put(key, desc);
        fgImageDescriptors.put(key, desc);
    }

    private static URL makeIconFileURL(String iconPath) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        return new URL(ICON_BASE_URL, iconPath);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        if (fgImageDescriptors == null) {
            CommonUtils.initializeImageRegistry();
        }
        return fgImageDescriptors.get(key);
    }

    public static Image getImage(String key) {
        return CommonUtils.getImageRegistry().get(key);
    }

    private static void declareImages() {
        CommonUtils.declareRegistryImage("ICON_BREAKPOINT_INSTALLED", "ovr16/installed_ovr.png");
        CommonUtils.declareRegistryImage("ICON_BREAKPOINT_INSTALLED_DISABLED", "ovr16/installed_ovr_disabled.png");
        CommonUtils.declareRegistryImage("ICON_BREAKPOINT_CONDITIONAL", "ovr16/conditional_ovr.png");
        CommonUtils.declareRegistryImage("ICON_BREAKPOINT_CONDITIONAL_DISABLED", "ovr16/conditional_ovr_disabled.png");
        CommonUtils.declareRegistryImage("ICON_BREAKPOINT_ENTRY", "ovr16/entry_ovr.png");
        CommonUtils.declareRegistryImage("ICON_BREAKPOINT_ENTRY_DISABLED", "ovr16/entry_ovr_disabled.png");
        CommonUtils.declareRegistryImage("ICON_BREAKPOINT_EXIT", "ovr16/exit_ovr.png");
        CommonUtils.declareRegistryImage("ICON_BREAKPOINT_EXIT_DISABLED", "ovr16/exit_ovr_disabled.png");
        CommonUtils.declareRegistryImage("ICON_BREAKPOINT_ADDRESS", "ovr16/address_ovr.png");
        CommonUtils.declareRegistryImage("ICON_BREAKPOINT_ADDRESS_DISABLED", "ovr16/address_ovr_disabled.png");
        CommonUtils.declareRegistryImage("ICON_WATCHPOINT", "obj16/readwrite_obj.png");
        CommonUtils.declareRegistryImage("ICON_WATCHPOINT_DISABLED", "obj16/readwrite_obj_disabled.png");
        CommonUtils.declareRegistryImage("ICON_WATCHPOINT_ACCESS", "obj16/read_obj.png");
        CommonUtils.declareRegistryImage("ICON_WATCHPOINT_ACCESS_DISABLED", "obj16/read_obj_disabled.png");
        CommonUtils.declareRegistryImage("ICON_WATCHPOINT_MODIFICATION", "obj16/write_obj.png");
        CommonUtils.declareRegistryImage("ICON_WATCHPOINT_MODIFICATION_DISABLED", "obj16/write_obj_disabled.png");
        CommonUtils.declareRegistryImage("ICON_EXTRA_VARIABLES_TAB", "obj16/systemenv_tab.png");
        CommonUtils.declareRegistryImage("ICON_REALEDITOR_BREAKPOINT_ENABLED", "obj16/realeditor_brkp_obj.png");
        CommonUtils.declareRegistryImage("ICON_REALEDITOR_BREAKPOINT_DISABLED", "obj16/realeditor_brkpd_obj.png");
    }

    private static void declareBreakpointImages() {
        CommonUtils.declareCommonBreakpointImages();
        CommonUtils.declareRealEditorBreakpointImages();
    }

    private static void declareCommonBreakpointImages() {
        CommonUtils.createBreakpointImage(DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT"), 3, "COMMON_ICON_BREAKPOINT_ENABLED_INSTALLED");
        CommonUtils.createBreakpointImage(DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT_DISABLED"), 1, "COMMON_ICON_BREAKPOINT_DISABLED_INSTALLED");
    }

    private static void createBreakpointImage(ImageDescriptor baseImage, int statusFlag, String finalImageKey) {
        DebugImageDescriptor finalImage = new DebugImageDescriptor(baseImage, statusFlag);
        fgImageRegistry.put(finalImageKey, (ImageDescriptor)finalImage);
        fgImageDescriptors.put(finalImageKey, (ImageDescriptor)finalImage);
    }

    private static void declareRealEditorBreakpointImages() {
        ImageDescriptor[] baseImages = new ImageDescriptor[]{CommonUtils.getImageDescriptor("ICON_REALEDITOR_BREAKPOINT_ENABLED"), CommonUtils.getImageDescriptor("ICON_REALEDITOR_BREAKPOINT_DISABLED")};
        int[] nArray = new int[2];
        nArray[0] = 2;
        int[] enablementStatus = nArray;
        int[] statusFlags = new int[]{1, 4, 5};
        String[][] finalImageKeys = new String[][]{{"ICON_REALEDITOR_BREAKPOINT_ENABLED_INSTALLED", "ICON_REALEDITOR_BREAKPOINT_ENABLED_CONDITIONAL", "ICON_REALEDITOR_BREAKPOINT_ENABLED_INSTALLED_CONDITIONAL"}, {"ICON_REALEDITOR_BREAKPOINT_DISABLED_INSTALLED", "ICON_REALEDITOR_BREAKPOINT_DISABLED_CONDITIONAL", "ICON_REALEDITOR_BREAKPOINT_DISABLED_INSTALLED_CONDITIONAL"}};
        int i = 0;
        while (i < baseImages.length && i < enablementStatus.length && i < finalImageKeys.length) {
            int j = 0;
            while (j < statusFlags.length && j < finalImageKeys[i].length) {
                CommonUtils.createBreakpointImage(baseImages[i], enablementStatus[i] | statusFlags[j], finalImageKeys[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public static String getNonMnemonicString(String str) {
        int indexOfAmpersand = ((String)str).indexOf("&", 0);
        while (indexOfAmpersand >= 0) {
            str = ((String)str).substring(0, indexOfAmpersand) + "&" + ((String)str).substring(indexOfAmpersand, ((String)str).length());
            indexOfAmpersand += 2;
            indexOfAmpersand = ((String)str).indexOf("&", indexOfAmpersand);
        }
        return str;
    }

    public static final IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            try {
                return workbench.getActiveWorkbenchWindow();
            }
            catch (SWTException e) {
                return null;
            }
        }
        return null;
    }

    public static final Shell getShell() {
        final Shell[] shell = new Shell[1];
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                shell[0] = display.getActiveShell();
            }
        });
        return shell[0];
    }

    public static final Shell getWorkbenchShell() {
        final Shell[] shell = new Shell[1];
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    shell[0] = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        return shell[0];
    }

    public static final Display getDisplay() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            return workbench.getDisplay();
        }
        return null;
    }

    public static void showView(String viewId) {
        try {
            IWorkbenchPage p = CommonUtils.getActiveWorkbenchWindow().getActivePage();
            if (p == null) {
                return;
            }
            p.showView(viewId);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
    }

    public static boolean asyncShowView(final String viewId) {
        Display display = CommonUtils.getDisplay();
        if (display == null) {
            return false;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                CommonUtils.showView(viewId);
            }
        });
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static String[] getUserAndSystemEnvironmentVariables(ILaunchConfiguration launchConfig) {
        String[] userAndSystemVars;
        List userVarsList;
        boolean systemIsNotCaseSensitive;
        block12: {
            systemIsNotCaseSensitive = CommonUtils.envVarsAreCaseSensitive();
            boolean showSystemVars = launchConfig.getAttribute("com.ibm.debug.pdt.common.showSystemEnvironmentVariables", false);
            userVarsList = launchConfig.getAttribute("com.ibm.debug.pdt.common.extraEnvironmentVariables", null);
            userAndSystemVars = null;
            if (showSystemVars) {
                if (userVarsList == null || userVarsList.isEmpty()) {
                    return new String[0];
                }
                userAndSystemVars = new String[userVarsList.size()];
                int i = 0;
                while (i < userAndSystemVars.length) {
                    userAndSystemVars[i] = ((String)userVarsList.get(i)).substring(1);
                    ++i;
                }
                return userAndSystemVars;
            }
            if (userVarsList != null && !userVarsList.isEmpty()) break block12;
            return null;
        }
        try {
            String nameKey;
            ArrayList<String> userVarNames = new ArrayList<String>(10);
            String[] systemVars = CommonUtils.getSystemEnvironmentVariables();
            ArrayList<String> userAndSystemVarsList = new ArrayList<String>(userVarsList.size() + systemVars.length);
            int i = 0;
            while (i < userVarsList.size()) {
                String userVarElement = ((String)userVarsList.get(i)).substring(1);
                nameKey = userVarElement.substring(0, userVarElement.indexOf(61));
                if (systemIsNotCaseSensitive) {
                    nameKey = nameKey.toUpperCase();
                }
                userVarNames.add(nameKey);
                userAndSystemVarsList.add(userVarElement);
                ++i;
            }
            i = systemVars.length - 1;
            while (i >= 0) {
                nameKey = systemVars[i].substring(0, systemVars[i].indexOf(61));
                if (systemIsNotCaseSensitive) {
                    nameKey = nameKey.toUpperCase();
                }
                if (!userVarNames.contains(nameKey)) {
                    userAndSystemVarsList.add(0, systemVars[i]);
                }
                --i;
            }
            userAndSystemVars = new String[userAndSystemVarsList.size()];
            i = 0;
            while (i < userAndSystemVarsList.size()) {
                userAndSystemVars[i] = (String)userAndSystemVarsList.get(i);
                ++i;
            }
            return userAndSystemVars;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    @Deprecated
    public static String[] getSystemEnvironmentVariables() {
        String command;
        block27: {
            String osName;
            block26: {
                osName = System.getProperty("os.name");
                command = null;
                if (osName != null) break block26;
                CommonUtils.logText("CommonUtils.getSystemEnvironmentVariables could not obtain environment variables: blank os.name");
                return null;
            }
            if (osName.equalsIgnoreCase("Windows NT")) {
                command = "cmd.exe /C set";
                break block27;
            }
            if (osName.equalsIgnoreCase("Windows 2000")) {
                command = "cmd.exe /C set";
                break block27;
            }
            if (osName.equalsIgnoreCase("Windows XP")) {
                command = "cmd.exe /C set";
                break block27;
            }
            if (osName.equalsIgnoreCase("Windows 95")) {
                command = "command.exe /C set";
                break block27;
            }
            if (osName.equalsIgnoreCase("Windows 98")) {
                command = "command.exe /C set";
                break block27;
            }
            if (osName.equalsIgnoreCase("Windows Me")) {
                command = "command.exe /C set";
                break block27;
            }
            if (osName.equalsIgnoreCase("Linux")) {
                command = "env";
                break block27;
            }
            if (osName.equalsIgnoreCase("HP-UX")) {
                command = "env";
                break block27;
            }
            if (osName.equalsIgnoreCase("AIX")) {
                command = "env";
                break block27;
            }
            if (osName.equalsIgnoreCase("Solaris")) {
                command = "env";
                break block27;
            }
            CommonUtils.logText("CommonUtils.getSystemEnvironmentVariables could not obtain environment variables: unknown os.name");
            return null;
        }
        try {
            Process proc = Runtime.getRuntime().exec(command);
            Vector<String> allEnvVars = new Vector<String>(20);
            InputStreamReader isr = new InputStreamReader(proc.getInputStream(), Charset.defaultCharset());
            Throwable throwable = null;
            Object var6_9 = null;
            try (BufferedReader br = new BufferedReader(isr);){
                String line = null;
                while ((line = br.readLine()) != null) {
                    allEnvVars.add(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            proc.waitFor();
            String[] envpArray = new String[allEnvVars.size()];
            Iterator iter = allEnvVars.iterator();
            int i = 0;
            while (iter.hasNext()) {
                envpArray[i] = (String)iter.next();
                ++i;
            }
            return envpArray;
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    public static boolean envVarsAreCaseSensitive() {
        String osName = System.getProperty("os.name");
        boolean caseSensitive = false;
        if (osName == null) {
            CommonUtils.logText("CommonUtils.envVarsAreCaseSensitive failure: blank os.name");
            return false;
        }
        if (osName.equalsIgnoreCase("Windows NT")) {
            caseSensitive = false;
        } else if (osName.equalsIgnoreCase("Windows 2000")) {
            caseSensitive = false;
        } else if (osName.equalsIgnoreCase("Windows XP")) {
            caseSensitive = false;
        } else if (osName.equalsIgnoreCase("Windows 95")) {
            caseSensitive = false;
        } else if (osName.equalsIgnoreCase("Windows 98")) {
            caseSensitive = false;
        } else if (osName.equalsIgnoreCase("Windows Me")) {
            caseSensitive = false;
        } else if (osName.equalsIgnoreCase("Linux")) {
            caseSensitive = true;
        } else if (osName.equalsIgnoreCase("HP-UX")) {
            caseSensitive = true;
        } else if (osName.equalsIgnoreCase("AIX")) {
            caseSensitive = true;
        } else if (osName.equalsIgnoreCase("Solaris")) {
            caseSensitive = true;
        }
        return caseSensitive;
    }

    public static IResource getSelectedResource(ISelection selected) {
        Object element;
        ISelection selection = selected;
        if (selection == null) {
            selection = CommonUtils.getActiveWorkbenchWindow().getSelectionService().getSelection();
        }
        if (selection != null && selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) != null && element instanceof IResource) {
            return (IResource)element;
        }
        return null;
    }

    public static String getProjectName(ISelection selection) {
        IResource resource = CommonUtils.getSelectedResource(selection);
        if (resource == null || resource.getProject() == null) {
            return EMPTY_STRING;
        }
        return resource.getProject().getName();
    }

    public static String getProjectName() {
        return CommonUtils.getProjectName(null);
    }

    public static String getProgramName(ISelection selection) {
        String fileExtension;
        IResource resource = CommonUtils.getSelectedResource(selection);
        if (resource != null && resource instanceof IFile && (fileExtension = ((IFile)resource).getFileExtension()) != null) {
            return resource.getWorkspace().getRoot().getLocation().toOSString() + resource.getFullPath().toOSString();
        }
        return EMPTY_STRING;
    }

    public static String getProgramName() {
        return CommonUtils.getProgramName(null);
    }
}

