/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.common;

import com.ibm.debug.pdt.internal.common.CommonUtils;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.Point;

public class DebugImageDescriptor
extends CompositeImageDescriptor {
    public static final int INSTALLED = 1;
    public static final int ENABLED = 2;
    public static final int CONDITIONAL = 4;
    public static final int ENTRY = 8;
    public static final int EXIT = 16;
    public static final int ADDRESS = 32;
    public static final int SKIP = 64;
    private ImageDescriptor fBaseImage;
    private int fControlFlags;
    private Point fSize;

    public DebugImageDescriptor(ImageDescriptor baseImage, int controlFlags) {
        this.fBaseImage = baseImage;
        this.fControlFlags = controlFlags;
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage((ImageDataProvider)this.createCachedImageDataProvider(this.fBaseImage), 0, 0);
        this.addOverlays();
    }

    protected Point getSize() {
        if (this.fSize == null) {
            ImageData data = this.fBaseImage.getImageData(100);
            this.fSize = new Point(data.width, data.height);
        }
        return this.fSize;
    }

    private void addOverlays() {
        CompositeImageDescriptor.CachedImageDataProvider provider;
        Image data = null;
        int x = 0;
        int y = 0;
        if ((this.fControlFlags & 1) != 0) {
            x = 0;
            y = this.getSize().y;
            data = (this.fControlFlags & 2) != 0 ? CommonUtils.getImage("ICON_BREAKPOINT_INSTALLED") : CommonUtils.getImage("ICON_BREAKPOINT_INSTALLED_DISABLED");
            provider = this.createCachedImageDataProvider(data);
            this.drawImage((ImageDataProvider)provider, x, y -= provider.getHeight());
        }
        if ((this.fControlFlags & 4) != 0) {
            x = this.getSize().x;
            y = 0;
            data = (this.fControlFlags & 2) != 0 ? CommonUtils.getImage("ICON_BREAKPOINT_CONDITIONAL") : CommonUtils.getImage("ICON_BREAKPOINT_CONDITIONAL_DISABLED");
            provider = this.createCachedImageDataProvider(data);
            this.drawImage((ImageDataProvider)provider, x -= provider.getWidth(), y);
        }
        if ((this.fControlFlags & 8) != 0) {
            x = 0;
            y = 0;
            data = (this.fControlFlags & 2) != 0 ? CommonUtils.getImage("ICON_BREAKPOINT_ENTRY") : CommonUtils.getImage("ICON_BREAKPOINT_ENTRY_DISABLED");
            provider = this.createCachedImageDataProvider(data);
            this.drawImage((ImageDataProvider)provider, x, y);
        }
        if ((this.fControlFlags & 0x10) != 0) {
            x = this.getSize().x;
            y = this.getSize().y;
            data = (this.fControlFlags & 2) != 0 ? CommonUtils.getImage("ICON_BREAKPOINT_EXIT") : CommonUtils.getImage("ICON_BREAKPOINT_EXIT_DISABLED");
            provider = this.createCachedImageDataProvider(data);
            this.drawImage((ImageDataProvider)provider, x -= provider.getWidth(), y -= provider.getHeight());
        }
        if ((this.fControlFlags & 0x20) != 0) {
            x = 0;
            y = 0;
            data = (this.fControlFlags & 2) != 0 ? CommonUtils.getImage("ICON_BREAKPOINT_ADDRESS") : CommonUtils.getImage("ICON_BREAKPOINT_ADDRESS_DISABLED");
            provider = this.createCachedImageDataProvider(data);
            this.drawImage((ImageDataProvider)provider, x, y);
        }
    }
}

