/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.playback.internal.preferences;

import com.ibm.debug.pdt.internal.epdc.ERepGetPlaybackOptions;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugTitleAreaDialog;
import com.ibm.debug.pdt.playback.internal.PlaybackMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class EditOptionDialog
extends DebugTitleAreaDialog
implements SelectionListener,
ModifyListener {
    private String fStringValue = null;
    private ERepGetPlaybackOptions fOption;
    private Text fText = null;
    private List fList = null;
    private Button fAddButton = null;
    private Button fRemoveButton = null;
    private String[] fListValues = null;

    public EditOptionDialog(Shell shell, ERepGetPlaybackOptions option, String stringValue) {
        super(shell);
        this.fOption = option;
        this.fStringValue = stringValue;
    }

    public EditOptionDialog(Shell shell, ERepGetPlaybackOptions option, String[] list) {
        super(shell);
        this.fOption = option;
        this.fListValues = list;
    }

    private void addItem() {
        this.fList.add(this.fText.getText());
        this.fText.setText("");
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.fOption.getName().toString());
        this.setMessage(PlaybackMessages.SPECIFY_OPTION);
        Composite result = (Composite)super.createDialogArea(parent);
        Composite comp = new Composite(result, 0);
        boolean isList = ERepGetPlaybackOptions.isListType((int)this.fOption.getType());
        comp.setLayoutData((Object)new GridData(1808));
        int numColumns = 1;
        if (isList) {
            numColumns = 2;
        }
        GridLayout layout = new GridLayout(numColumns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        Label label = new Label(comp, 0);
        label.setText(this.fOption.getName().toString());
        GridData gd = new GridData(768);
        gd.horizontalSpan = numColumns;
        label.setLayoutData((Object)gd);
        this.fText = new Text(comp, 16388);
        gd = new GridData(768);
        this.fText.setLayoutData((Object)gd);
        this.fText.setText(this.fStringValue);
        if (isList) {
            this.fText.addModifyListener((ModifyListener)this);
            this.fAddButton = new Button(comp, 8);
            this.fAddButton.setText(PlaybackMessages.ADD);
            this.fAddButton.addSelectionListener((SelectionListener)this);
            this.fList = new List(comp, 0);
            gd = new GridData(768);
            gd.verticalSpan = 2;
            this.fList.setLayoutData((Object)gd);
            this.fList.addSelectionListener((SelectionListener)this);
            this.fRemoveButton = new Button(comp, 8);
            this.fRemoveButton.addSelectionListener((SelectionListener)this);
            this.fRemoveButton.setText(PlaybackMessages.REMOVE);
        }
        this.initValues();
        return result;
    }

    private void enableButtons() {
        if (this.fAddButton != null) {
            this.fAddButton.setEnabled(this.fText.getText().trim().length() > 0);
        }
        if (this.fRemoveButton != null) {
            this.fRemoveButton.setEnabled(this.fList.getSelectionCount() > 0);
        }
    }

    private String getListText() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.fList.getItemCount()) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.fList.getItem(i));
            ++i;
        }
        return sb.toString();
    }

    public String getReturnedString() {
        return this.fStringValue;
    }

    private void initValues() {
        if (this.fStringValue != null) {
            this.fText.setText(this.fStringValue);
        }
        if (this.fListValues != null) {
            int i = 0;
            while (i < this.fListValues.length) {
                this.fList.add(this.fListValues[i]);
                ++i;
            }
        }
    }

    protected boolean isResizable() {
        return true;
    }

    public void modifyText(ModifyEvent e) {
        this.enableButtons();
    }

    protected void okPressed() {
        if (this.fList != null) {
            this.fStringValue = this.getListText();
        } else if (this.fText != null) {
            this.fStringValue = this.fText.getText();
        }
        super.okPressed();
    }

    private void removeSelectedItems() {
        String[] selection = this.fList.getSelection();
        if (selection != null) {
            int i = 0;
            while (i < selection.length) {
                this.fList.remove(selection[i]);
                ++i;
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.fAddButton) {
            this.addItem();
        } else if (e.getSource() == this.fRemoveButton) {
            this.removeSelectedItems();
        }
        this.enableButtons();
    }
}

