/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.playback.internal.handlers;

import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EPDC_Reply;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.epdc.ERepPlaybackControl;
import com.ibm.debug.pdt.internal.epdc.EReqPlaybackControl;
import com.ibm.debug.pdt.playback.internal.PlaybackStateCache;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;

public abstract class AbstractPlaybackControlHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IAdaptable item = DebugUITools.getDebugContext();
        if (item instanceof PDTDebugElement) {
            PDTDebugElement debugElement = (PDTDebugElement)item;
            DebugEngine engine = debugElement.getDebugEngine();
            try {
                EPDC_Reply reply = engine.processRequest((EPDC_Request)new EReqPlaybackControl(debugElement.getEngineSession(), this.getPlaybackControlID()));
                if (reply instanceof ERepPlaybackControl) {
                    if (reply.getReturnCode() == 0) {
                        PlaybackStateCache.updatePlaybackStateFromReply(engine, (ERepPlaybackControl)reply);
                        this.checkReply((ERepPlaybackControl)reply);
                    } else {
                        PDTCoreUtils.logString((Object)((Object)this), (String)AbstractPlaybackControlHandler.getReplyMessage(reply), (int)2);
                    }
                }
            }
            catch (EngineRequestException e) {
                PDTCoreUtils.logString((Object)((Object)this), (String)(e.getMessage() != null ? e.getMessage() : e.toString()), (int)4, (Exception)((Object)e));
            }
        }
        return null;
    }

    protected void checkReply(ERepPlaybackControl reply) {
    }

    protected abstract int getPlaybackControlID();

    static String getReplyMessage(EPDC_Reply reply) {
        StringBuilder message = new StringBuilder();
        if (reply.getMessageText() != null) {
            message.append(reply.getMessageText());
        }
        message.append("(rc=");
        message.append(reply.getReturnCode());
        message.append(",replyCode=");
        message.append(reply.getReplyCode());
        message.append(')');
        return message.toString();
    }
}

