/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.playback.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.ExtensionContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.services.IServiceLocator;

public class PlaybackViewMenuContributionFactory
extends ExtensionContributionFactory
implements IMenuListener {
    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        this.initDebugViewMenu();
    }

    private void initDebugViewMenu() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            if (window.getActivePage() != null) {
                IActionBars bars;
                IViewPart view;
                IViewReference reference = window.getActivePage().findViewReference("org.eclipse.debug.ui.DebugView");
                if (reference != null && (view = reference.getView(false)) != null && view.getSite() instanceof IViewSite && (bars = ((IViewSite)view.getSite()).getActionBars()) != null) {
                    IMenuManager manager = bars.getMenuManager();
                    manager.addMenuListener((IMenuListener)this);
                }
            } else {
                Job job = new Job(""){

                    protected IStatus run(IProgressMonitor arg0) {
                        try {
                            while (PlatformUI.getWorkbench().getActiveWorkbenchWindow() == null) {
                                Thread.sleep(100L);
                            }
                            while (PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() == null) {
                                Thread.sleep(100L);
                            }
                            PlaybackViewMenuContributionFactory.this.initDebugViewMenu();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }
    }

    public void menuAboutToShow(IMenuManager manager) {
        IContributionItem[] items = manager.getItems();
        int showDebugToolbarIndex = -1;
        int showPlaybackToolbarIndex = -1;
        int i = 0;
        while (i < items.length && (showDebugToolbarIndex == -1 || showPlaybackToolbarIndex == -1)) {
            if (items[i].getId() != null && items[i].getId().equals("com.ibm.debug.pdt.playback.menu.showToolbar")) {
                showPlaybackToolbarIndex = i;
            } else if (items[i] instanceof ActionContributionItem && ((ActionContributionItem)items[i]).getAction().getClass().getName().equals("org.eclipse.debug.internal.ui.views.launch.DebugToolBarAction")) {
                showDebugToolbarIndex = i;
            }
            ++i;
        }
        if (showDebugToolbarIndex + 1 != showPlaybackToolbarIndex && showPlaybackToolbarIndex != -1) {
            manager.removeAll();
            manager.update(true);
            i = 0;
            while (i < items.length) {
                if (i != showPlaybackToolbarIndex) {
                    manager.add(items[i]);
                    if (i == showDebugToolbarIndex) {
                        manager.add(items[showPlaybackToolbarIndex]);
                    }
                }
                ++i;
            }
            manager.removeMenuListener((IMenuListener)this);
        }
    }
}

