/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.playback.internal;

import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.playback.internal.PlaybackStateCache;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jface.viewers.IStructuredSelection;

public class PlaybackPropertyTester
extends PropertyTester {
    protected static final String PLAYBACK_ALLOWED_PROPERTY = "playbackAllowed";
    protected static final String MOVE_BACK_ALLOWED_PROPERTY = "moveBackAllowed";
    protected static final String MOVE_FORWARD_ALLOWED_PROPERTY = "moveForwardAllowed";
    protected static final String RESUME_ALLOWED_PROPERTY = "resumeAllowed";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Object element;
        boolean value = false;
        if (receiver instanceof IStructuredSelection && (element = ((IStructuredSelection)receiver).getFirstElement()) instanceof PDTDebugElement) {
            boolean isThreadOrStackFrame;
            boolean resumeEnabled = ((PDTDebugElement)element).getDebugTarget().canResume() && !(element instanceof IProcess);
            boolean bl = isThreadOrStackFrame = element instanceof IThread || element instanceof IStackFrame;
            if (resumeEnabled) {
                if (property.equalsIgnoreCase(PLAYBACK_ALLOWED_PROPERTY)) {
                    IDebugTarget target = ((PDTDebugElement)element).getDebugTarget();
                    value = target instanceof PDTDebugTarget && !((PDTDebugTarget)target).isDisconnected() && !((PDTDebugTarget)target).isTerminated() && ((PDTDebugTarget)target).supportsPlayback();
                } else if (property.equalsIgnoreCase(MOVE_BACK_ALLOWED_PROPERTY)) {
                    value = isThreadOrStackFrame && PlaybackStateCache.isMoveBackAllowed(((PDTDebugElement)element).getDebugEngine());
                } else if (property.equalsIgnoreCase(MOVE_FORWARD_ALLOWED_PROPERTY)) {
                    value = isThreadOrStackFrame && PlaybackStateCache.isMoveForwardAllowed(((PDTDebugElement)element).getDebugEngine());
                } else if (property.equalsIgnoreCase(RESUME_ALLOWED_PROPERTY)) {
                    value = isThreadOrStackFrame && PlaybackStateCache.isMoveForwardAllowed(((PDTDebugElement)element).getDebugEngine());
                }
            }
        }
        return Boolean.valueOf(value).equals(expectedValue);
    }
}

