/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memoryoffset;

import com.ibm.debug.memoryoffset.IOffsetRendering;
import com.ibm.debug.memoryoffset.OffsetRenderingWorker;
import java.math.BigInteger;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractBaseTableRendering;
import org.eclipse.debug.internal.ui.views.memory.renderings.UnsignedIntegerRendering;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;

public class OffsetUnsignedIntegerRendering
extends UnsignedIntegerRendering
implements IOffsetRendering {
    private OffsetRenderingWorker fDoitThing = new OffsetRenderingWorker((AbstractBaseTableRendering)this);
    private int fInitialMode;
    private PropertyChangeEvent fQueuedEvent = null;
    private IPropertyChangeListener fCreator = null;

    public OffsetUnsignedIntegerRendering(String renderingId, int initialMode, IPropertyChangeListener creator) {
        super(renderingId);
        this.fInitialMode = initialMode;
        this.fCreator = creator;
    }

    @Override
    public int getOffsetMode() {
        return this.fDoitThing.getOffsetMode();
    }

    @Override
    public void setOffsetMode(int newMode) {
        int oldVal = this.fDoitThing.getOffsetMode();
        ISelection selection = this.getViewer().getSelection();
        this.fDoitThing.setOffsetMode(newMode);
        this.getViewer().setSelection(selection);
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "DISPLAY_MODE_CHANGE", (Object)oldVal, (Object)this.fDoitThing.getOffsetMode());
        this.firePropertyChangedEvent(event);
    }

    protected String getToolTipText(BigInteger address, MemoryByte[] bytes) {
        return this.fDoitThing.getToolTipText(address, bytes, super.getToolTipText(address, bytes));
    }

    public boolean format(int bytesPerLine, int columnSize) {
        boolean ret = super.format(bytesPerLine, columnSize);
        this.refresh();
        return ret;
    }

    public void propertyChange(PropertyChangeEvent event) {
        PropertyChangeEvent e = this.fDoitThing.propertyChange(event);
        if (e == null) {
            e = event;
        }
        if (e.getProperty().equals("DISPLAY_MODE_CHANGE")) {
            if (!this.isVisible()) {
                this.fQueuedEvent = event;
            } else {
                this.fDoitThing.setOffsetMode((Integer)e.getNewValue());
            }
        }
        super.propertyChange(e);
    }

    public void becomesVisible() {
        if (this.fQueuedEvent != null && this.fQueuedEvent.getProperty().equals("DISPLAY_MODE_CHANGE") && this.fQueuedEvent.getSource() instanceof IOffsetRendering && this.getMemoryBlock().equals(((IOffsetRendering)this.fQueuedEvent.getSource()).getMemoryBlock())) {
            int newMode = (Integer)this.fQueuedEvent.getNewValue();
            this.fDoitThing.setOffsetMode(newMode);
            this.fQueuedEvent = null;
        }
        super.becomesVisible();
    }

    public void activated() {
        super.activated();
        PropertyChangeEvent e = new PropertyChangeEvent((Object)this, "DISPLAY_MODE_CHANGE", (Object)this.fDoitThing.getOffsetMode(), (Object)this.fDoitThing.getOffsetMode());
        this.firePropertyChangedEvent(e);
    }

    protected void createActions() {
        super.createActions();
        this.fDoitThing.setOffsetMode(this.fInitialMode);
        if (this.getMemoryRenderingContainer() != null && this.getMemoryRenderingContainer().getMemoryRenderingSite() != null && this.getMemoryRenderingContainer().getMemoryRenderingSite().getSynchronizationService() != null) {
            this.getMemoryRenderingContainer().getMemoryRenderingSite().getSynchronizationService().addPropertyChangeListener(this.fCreator, null);
        }
    }

    @Override
    public BigInteger modifyAddressForOffsetMode(BigInteger addressToModify) {
        return this.fDoitThing.modifyAddressForOffsetMode(addressToModify);
    }

    public String getString(String dataType, BigInteger address, MemoryByte[] data) {
        if (address.compareTo(BigInteger.valueOf(0L)) < 0) {
            return this.fDoitThing.getStringForInvalidMemory(data);
        }
        String result = this.fDoitThing.getStringForNotAuthorizedMemory(data);
        if (result != null) {
            return result;
        }
        return super.getString(dataType, address, data);
    }
}

