/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memoryoffset;

import com.ibm.debug.memoryoffset.MemoryOffsetLabels;
import java.math.BigInteger;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractBaseTableRendering;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingContentDescriptor;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.util.PropertyChangeEvent;

public class OffsetRenderingWorker {
    private static final String UNDISPLAYABLE_MEMORY_PADDING_STRING = "*";
    private int fOffsetMode = 1;
    private AbstractBaseTableRendering fTableRendering;
    private String fInvalidPaddedString;
    public static String CONTROL_CREATED = "CONTROL_CREATED";

    public OffsetRenderingWorker(AbstractBaseTableRendering tableRendering) {
        this.fTableRendering = tableRendering;
        this.fInvalidPaddedString = DebugUITools.getPreferenceStore().getString("org.eclipse.debug.ui.memory.paddedStr");
    }

    public void setOffsetMode(int newMode) {
        if (newMode != this.fOffsetMode) {
            this.fOffsetMode = newMode;
            boolean align = this.fOffsetMode != 2;
            ((TableRenderingContentDescriptor)this.fTableRendering.getAdapter(TableRenderingContentDescriptor.class)).setAlignAddressToBoundary(align);
            this.fTableRendering.refresh();
        }
    }

    public int getOffsetMode() {
        return this.fOffsetMode;
    }

    protected String getToolTipText(BigInteger address, MemoryByte[] bytes, String renderingText) {
        BigInteger offset = address.subtract(BigInteger.valueOf(this.fTableRendering.getMemoryBlock().getStartAddress()));
        String offsetDec = offset.toString();
        StringBuffer buf = new StringBuffer();
        if (offset.compareTo(new BigInteger("0")) < 0) {
            buf.append("-");
            offset = offset.negate();
        }
        buf.append("0x");
        buf.append(offset.toString(16).toUpperCase());
        if (renderingText.indexOf(45) != -1) {
            StringBuffer stringBuf = new StringBuffer(renderingText);
            stringBuf.deleteCharAt(renderingText.indexOf(45));
            stringBuf.insert(0, '-');
            renderingText = stringBuf.toString();
        }
        String ret = MemoryOffsetLabels.NewOffsetRenderingWorker_Address + " " + renderingText + "\r\n" + MemoryOffsetLabels.NewOffsetRenderingWorker_Offset + " " + offsetDec + " [" + buf.toString() + "]";
        return ret;
    }

    public PropertyChangeEvent propertyChange(PropertyChangeEvent event) {
        return null;
    }

    public BigInteger modifyAddressForOffsetMode(BigInteger addressToModify) {
        BigInteger monitoredAddress;
        long bytesPerLine = this.fTableRendering.getBytesPerLine();
        try {
            monitoredAddress = ((IMemoryBlockExtension)this.fTableRendering.getMemoryBlock()).getBigBaseAddress();
        }
        catch (DebugException e) {
            return addressToModify;
        }
        monitoredAddress = monitoredAddress.subtract(monitoredAddress.mod(BigInteger.valueOf(this.fTableRendering.getBytesPerColumn())));
        BigInteger monitoredAddressOffsetFromRowStart = monitoredAddress.mod(BigInteger.valueOf(bytesPerLine));
        BigInteger addressToModifyOffsetFromRowStart = addressToModify.mod(BigInteger.valueOf(bytesPerLine));
        BigInteger offset = monitoredAddressOffsetFromRowStart.subtract(addressToModifyOffsetFromRowStart);
        return addressToModify.add(offset);
    }

    public int getBytesPerLine() {
        return this.fTableRendering.getBytesPerLine();
    }

    String getStringForInvalidMemory(MemoryByte[] data) {
        StringBuilder ret = new StringBuilder("");
        int n = 0;
        while (n < data.length) {
            ret.append(this.fInvalidPaddedString);
            ++n;
        }
        return ret.toString();
    }

    String getStringForNotAuthorizedMemory(MemoryByte[] data) {
        boolean containNotAuthorizedBytes = false;
        int i = 0;
        while (i < data.length) {
            if ((data[i].getFlags() & 0xFFFFFF80) == -128) {
                containNotAuthorizedBytes = true;
                break;
            }
            ++i;
        }
        if (!containNotAuthorizedBytes) {
            return null;
        }
        StringBuilder ret = new StringBuilder("");
        int n = 0;
        while (n < data.length) {
            ret.append(UNDISPLAYABLE_MEMORY_PADDING_STRING);
            ++n;
        }
        return ret.toString();
    }

    String padNotAuthorizedMemory(String columnText, MemoryByte[] data) {
        int labelLength = columnText.length();
        int bytesLength = data.length;
        int sizePerByte = labelLength / bytesLength;
        StringBuilder stringBuilder = new StringBuilder(columnText);
        int i = 0;
        while (i < data.length) {
            if ((data[i].getFlags() & 0xFFFFFF80) == -128) {
                int j = 0;
                while (j < sizePerByte) {
                    stringBuilder.replace(i * sizePerByte + j, i * sizePerByte + j + 1, UNDISPLAYABLE_MEMORY_PADDING_STRING);
                    ++j;
                }
            }
            ++i;
        }
        return stringBuilder.toString();
    }
}

