/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memoryoffset;

import com.ibm.debug.memoryoffset.IOffsetRendering;
import com.ibm.debug.memoryoffset.OffsetHexRendering;
import com.ibm.debug.memoryoffset.OffsetSignedIntegerRendering;
import com.ibm.debug.memoryoffset.OffsetTextRendering;
import com.ibm.debug.memoryoffset.OffsetUnsignedIntegerRendering;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingTypeDelegate;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class OffsetRenderingDelegate
implements IMemoryRenderingTypeDelegate,
IPropertyChangeListener {
    public static final String PREF_RENDERING_MODE = "RENDERING_MODE";
    private static final String PLUGIN_ID = "com.ibm.debug.memoryoffset";
    private static int fInitialMode;
    private static final Object fLock;
    private static int fDefaultRenderingMode;

    static {
        fLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OffsetRenderingDelegate() {
        ScopedPreferenceStore preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, PLUGIN_ID);
        if (!preferenceStore.contains(PREF_RENDERING_MODE)) {
            preferenceStore.setValue(PREF_RENDERING_MODE, 1);
        }
        Object object = fLock;
        synchronized (object) {
            fDefaultRenderingMode = preferenceStore.getInt(PREF_RENDERING_MODE);
            fInitialMode = preferenceStore.getInt(PREF_RENDERING_MODE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMemoryRendering createRendering(String id) throws CoreException {
        IOffsetRendering rendering = null;
        Object object = fLock;
        synchronized (object) {
            if (id.equalsIgnoreCase("com.ibm.debug.offsetmemory.rendering.newhex")) {
                rendering = new OffsetHexRendering(id, fInitialMode, this);
            } else if (id.equalsIgnoreCase("com.ibm.debug.offsetmemory.rendering.newsignedint")) {
                rendering = new OffsetSignedIntegerRendering(id, fInitialMode, this);
            } else if (id.equalsIgnoreCase("com.ibm.debug.offsetmemory.rendering.newunsignedint")) {
                rendering = new OffsetUnsignedIntegerRendering(id, fInitialMode, this);
            } else if (id.equalsIgnoreCase("com.ibm.debug.offsetmemory.rendering.newascii")) {
                rendering = new OffsetTextRendering(id, "org.eclipse.debug.ui.defaultAsciiCodePage", fInitialMode, this);
            } else if (id.equalsIgnoreCase("com.ibm.debug.offsetmemory.rendering.newebcdic")) {
                rendering = new OffsetTextRendering(id, "org.eclipse.debug.ui.defaultEbcdicCodePage", fInitialMode, this);
            }
        }
        return rendering;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("DISPLAY_MODE_CHANGE")) {
            Object object = fLock;
            synchronized (object) {
                fInitialMode = (Integer)event.getNewValue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDefaultRenderingMode() {
        Object object = fLock;
        synchronized (object) {
            return fDefaultRenderingMode;
        }
    }
}

