/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memoryoffset;

import com.ibm.debug.memoryoffset.IOffsetRendering;
import com.ibm.debug.memoryoffset.OffsetMemorySegment;
import java.math.BigInteger;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.elements.adapters.MemoryBlockContentAdapter;
import org.eclipse.debug.internal.ui.memory.provisional.MemoryViewPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractBaseTableRendering;
import org.eclipse.debug.internal.ui.views.memory.renderings.MemorySegment;
import org.eclipse.debug.ui.memory.IMemoryRendering;

public class OffsetMemoryBlockContentAdapter
extends MemoryBlockContentAdapter {
    protected Object[] getChildren(Object parent, IPresentationContext context) throws CoreException {
        Object[] children = super.getChildren(parent, context);
        Object[] ret = new Object[children.length];
        int n = 0;
        while (n < children.length) {
            if (children[n] instanceof MemorySegment) {
                ret[n] = new OffsetMemorySegment((MemorySegment)children[n]);
            }
            ++n;
        }
        return ret;
    }

    public Object[] getMemoryToFitTable(BigInteger startAddress, long numberOfLines, MemoryViewPresentationContext context) throws DebugException {
        IMemoryRendering rendering = context.getRendering();
        boolean isOffset = false;
        if (rendering instanceof IOffsetRendering) {
            isOffset = ((IOffsetRendering)rendering).getOffsetMode() == 2;
        }
        BigInteger shiftedStartAddress = startAddress;
        Vector<Object> lines = null;
        if (isOffset) {
            shiftedStartAddress = ((IOffsetRendering)rendering).modifyAddressForOffsetMode(startAddress);
            int shiftAmount = shiftedStartAddress.subtract(startAddress).intValue();
            IMemoryBlockExtension block = (IMemoryBlockExtension)rendering.getMemoryBlock();
            BigInteger blockHardStart = block.getMemoryBlockStartAddress();
            if (blockHardStart == null) {
                blockHardStart = BigInteger.valueOf(0L);
            }
            if (shiftAmount > 0 && startAddress.compareTo(blockHardStart) <= 0 && rendering instanceof AbstractBaseTableRendering) {
                int bytesPerLine = ((AbstractBaseTableRendering)rendering).getBytesPerLine();
                MemoryByte[] bytes = new MemoryByte[bytesPerLine];
                MemoryByte[] skippedBytes = block.getBytesFromAddress(blockHardStart, (long)shiftAmount);
                int fillerAmount = bytesPerLine - shiftAmount;
                int i = 0;
                while (i < fillerAmount) {
                    bytes[i] = new MemoryByte();
                    ++i;
                }
                i = fillerAmount;
                int j = 0;
                while (i < bytesPerLine) {
                    bytes[i] = skippedBytes[j];
                    ++i;
                    ++j;
                }
                MemorySegment seg = new MemorySegment(BigInteger.valueOf(fillerAmount * -1), bytes, bytes.length);
                lines = new Vector<Object>();
                lines.add(seg);
            }
        }
        if (lines == null) {
            return super.getMemoryToFitTable(shiftedStartAddress, numberOfLines, context);
        }
        Object[] objs = super.getMemoryToFitTable(shiftedStartAddress, numberOfLines, context);
        int i = 0;
        while (i < objs.length) {
            lines.add(objs[i]);
            ++i;
        }
        return lines.toArray();
    }
}

