/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memoryoffset;

import com.ibm.debug.memoryoffset.IOffsetRendering;
import java.math.BigInteger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.internal.ui.elements.adapters.MemorySegmentLabelAdapter;
import org.eclipse.debug.internal.ui.memory.provisional.AbstractAsyncTableRendering;
import org.eclipse.debug.internal.ui.memory.provisional.MemoryViewPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;

public class OffsetLabelAdapter
extends MemorySegmentLabelAdapter {
    protected String[] getLabels(Object element, IPresentationContext context) throws CoreException {
        IOffsetRendering rendering;
        String[] originalLabels = super.getLabels(element, context);
        if (context instanceof MemoryViewPresentationContext && ((MemoryViewPresentationContext)context).getRendering() instanceof IOffsetRendering && ((MemoryViewPresentationContext)context).getRendering() instanceof AbstractAsyncTableRendering && (rendering = (IOffsetRendering)((MemoryViewPresentationContext)context).getRendering()).getOffsetMode() == 2) {
            int negIndex = originalLabels[0].indexOf(45);
            if (negIndex != -1) {
                StringBuffer addr = new StringBuffer(originalLabels[0]);
                addr.deleteCharAt(negIndex);
                addr.insert(0, '-');
                originalLabels[0] = addr.toString();
            }
            BigInteger addressVal = new BigInteger(originalLabels[0], 16);
            addressVal = addressVal.subtract(((IMemoryBlockExtension)rendering.getMemoryBlock()).getBigBaseAddress());
            BigInteger mod = addressVal.remainder(BigInteger.valueOf(((AbstractAsyncTableRendering)rendering).getBytesPerColumn()));
            addressVal = addressVal.subtract(mod);
            boolean negative = false;
            if (addressVal.compareTo(BigInteger.ZERO) < 0) {
                negative = true;
                addressVal = addressVal.negate();
            }
            String stringRep = addressVal.toString(16).toUpperCase();
            Object padding = " ";
            if (negative) {
                padding = "-";
            }
            int i = 0;
            while (i < originalLabels[0].length() - stringRep.length() - 1) {
                padding = (String)padding + "0";
                ++i;
            }
            originalLabels[0] = (String)padding + stringRep;
        }
        return originalLabels;
    }
}

