/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.ic.server.jobs;

import com.ibm.ccl.help.preferenceharvester.LocalHelp;
import com.ibm.ut.help.common.ic.IC;
import com.ibm.ut.help.common.prefs.ICPreferences;
import com.ibm.ut.help.common.prefs.UpdaterPreferences;
import com.ibm.ut.help.common.web.URLUtil;
import com.ibm.ut.help.state.State;
import com.ibm.ut.ic.server.Activator;
import com.ibm.ut.ic.server.LocalServer;
import com.ibm.ut.ic.server.Messages;
import java.net.URL;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class InstallUpdateJob
extends Job {
    public InstallUpdateJob() {
        super(Messages.INSTALL_UPDATES);
    }

    protected IStatus run(IProgressMonitor monitor) {
        boolean autoUpdate = UpdaterPreferences.getAutoUpdate();
        if (!autoUpdate) {
            return Status.OK_STATUS;
        }
        if (this.remoteICsEnabled()) {
            return Status.OK_STATUS;
        }
        if (!LocalServer.getInstance().isStarted()) {
            return Status.OK_STATUS;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.INSTALLING_UPDATES, 100);
        int total = 0;
        String xid = UUID.randomUUID().toString();
        ConnectionThread ct = new ConnectionThread(xid);
        ct.start();
        while (!ct.isComplete()) {
            State state = LocalServer.getState(xid);
            if (state == null) {
                Activator.logWarning("Unable to connect to Local Server during InstallUpdatesJob");
                return Status.OK_STATUS;
            }
            monitor.subTask(state.getJob() + " " + state.getMessage());
            if (state.getPercent() > total) {
                // empty if block
            }
            monitor.worked(state.getPercent() - total);
            total = state.getPercent();
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    private boolean remoteICsEnabled() {
        List ics = ICPreferences.getICs();
        int i = 0;
        while (i < ics.size()) {
            if (((IC)ics.get(i)).isEnabled() && !((IC)ics.get(i)).getHost().equals("127.0.0.1")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    class ConnectionThread
    extends Thread {
        private boolean done = false;
        private String xid;

        public ConnectionThread(String xid) {
            this.xid = xid;
        }

        @Override
        public void run() {
            try {
                URL updateURL = new URL(LocalHelp.getLocalIC().getHref() + "/updater/config?op=InstallUpdates&xid=" + this.xid);
                URLUtil.getStream((URL)updateURL).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.done = true;
        }

        public boolean isComplete() {
            return this.done;
        }
    }
}

