/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.ic.server;

import com.ibm.ut.help.common.connector.PlatformConnector;
import com.ibm.ut.ic.server.Activator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class ZipFileUtility {
    static final int BUFFER_SIZE = 8192;

    public static boolean handleZipFileExtraction(String watchedFolder) {
        String destinationName = ZipFileUtility.getZipExtractDestination(watchedFolder);
        boolean canWriteToUpdates = false;
        if (destinationName.equals(watchedFolder)) {
            canWriteToUpdates = true;
        }
        ArrayList newZipFiles = ZipFileUtility.getNewZipFiles(watchedFolder, destinationName, canWriteToUpdates);
        int i = 0;
        while (i < newZipFiles.size()) {
            String currZipPath = (String)newZipFiles.get(i);
            destinationName = ZipFileUtility.getDestinationPathForZip(destinationName, currZipPath);
            ZipFileUtility.extractZipFile(currZipPath, destinationName);
            ++i;
        }
        return canWriteToUpdates;
    }

    public static void extractZipFile(String filePath, String destinationName) {
        ZipFileUtility.extractZipFile(filePath, destinationName, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void extractZipFile(String filePath, String destinationName, IProgressMonitor monitor) {
        if (!((String)destinationName).endsWith("/")) {
            destinationName = (String)destinationName + "/";
        }
        File src = new File(filePath);
        long size = src.length();
        int total = (int)size;
        monitor.beginTask("", total);
        if (Platform.getNL().contains("en")) {
            Activator.setTask(monitor, "Extracting contents from " + src.getName());
        }
        try {
            try {
                byte[] buf = new byte[8192];
                ZipInputStream zipInputStream = null;
                zipInputStream = new ZipInputStream(new FileInputStream(filePath));
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                while (zipEntry != null) {
                    int n;
                    Object entryName = (String)destinationName + zipEntry.getName();
                    entryName = ((String)entryName).replace('/', File.separatorChar);
                    entryName = ((String)entryName).replace('\\', File.separatorChar);
                    File newFile = new File((String)entryName);
                    if (zipEntry.isDirectory()) {
                        if (!newFile.mkdirs()) break;
                        zipEntry = zipInputStream.getNextEntry();
                        continue;
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream((String)entryName);
                    while ((n = zipInputStream.read(buf, 0, 8192)) > -1) {
                        fileOutputStream.write(buf, 0, n);
                        monitor.worked(n);
                    }
                    fileOutputStream.close();
                    zipInputStream.closeEntry();
                    zipEntry = zipInputStream.getNextEntry();
                }
                zipInputStream.close();
            }
            catch (Exception e) {
                Activator.logError("Unable to extract zip file", e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public static String getZipExtractDestination(String watchedFolder) {
        Object extractDestination = "";
        try {
            File watchedFolderFile = new File(watchedFolder);
            if (watchedFolderFile.canWrite()) {
                extractDestination = watchedFolder;
            } else {
                extractDestination = PlatformConnector.getConfigurationLocation().substring(0, PlatformConnector.getConfigurationLocation().lastIndexOf(File.separator)) + File.separator + "help" + File.separator + "updates";
                File destinationFile = new File((String)extractDestination);
                if (!destinationFile.exists()) {
                    destinationFile.mkdir();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Activator.logError("Unable to get zip extract destination", e);
        }
        return extractDestination;
    }

    public static String getUserConfigWatchedFolder() {
        return PlatformConnector.getConfigurationLocation().substring(0, PlatformConnector.getConfigurationLocation().lastIndexOf(File.separator)) + File.separator + "help" + File.separator + "updates";
    }

    public static ArrayList getNewZipFiles(String watchedFolder, String destinationName, boolean canWriteToUpdates) {
        ArrayList newZipFiles = new ArrayList();
        ArrayList<String> fileNames = new ArrayList<String>();
        ArrayList<String> fileFolders = new ArrayList<String>();
        try {
            File currFile;
            File fileFolder = new File(watchedFolder);
            File[] folderFiles = fileFolder.listFiles();
            if (folderFiles == null) {
                return newZipFiles;
            }
            int i = 0;
            while (i < folderFiles.length) {
                currFile = folderFiles[i];
                if (currFile.isDirectory()) {
                    fileFolders.add(currFile.getPath());
                } else {
                    fileNames.add(currFile.getPath());
                }
                ++i;
            }
            newZipFiles = ZipFileUtility.checkForNewZips(newZipFiles, fileNames, fileFolders);
            fileNames = new ArrayList();
            fileFolders = new ArrayList();
            if (!canWriteToUpdates) {
                fileFolder = new File(destinationName);
                folderFiles = fileFolder.listFiles();
                i = 0;
                while (i < folderFiles.length) {
                    currFile = folderFiles[i];
                    if (currFile.isDirectory()) {
                        fileFolders.add(currFile.getPath());
                    } else {
                        fileNames.add(currFile.getPath());
                    }
                    ++i;
                }
                newZipFiles = ZipFileUtility.checkForNewZips(newZipFiles, fileNames, fileFolders);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newZipFiles;
    }

    public static ArrayList checkForNewZips(ArrayList newZipList, ArrayList fileList, ArrayList folderList) {
        int i = 0;
        while (i < fileList.size()) {
            int zipIndex;
            String folderToken;
            String currFile = (String)fileList.get(i);
            if (currFile.endsWith(".zip") && !folderList.contains(folderToken = currFile.substring(0, zipIndex = currFile.lastIndexOf(".zip")))) {
                newZipList.add(currFile);
            }
            ++i;
        }
        return newZipList;
    }

    public static String getDestinationPathForZip(String destinationName, String zipPath) {
        Object updatedDestination = "";
        int endPathIndex = zipPath.lastIndexOf(File.separator);
        int zipIndex = zipPath.lastIndexOf(".zip");
        String zipFolderName = zipPath.substring(endPathIndex + 1, zipIndex);
        updatedDestination = destinationName + File.separator + zipFolderName + File.separator;
        return updatedDestination;
    }
}

