/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.ic.server;

import com.ibm.ccl.help.preferenceharvester.LocalHelp;
import com.ibm.ut.help.common.web.URLUtil;
import com.ibm.ut.help.state.State;
import com.ibm.ut.ic.server.Activator;
import com.ibm.ut.ic.server.AlreadyBoundException;
import com.ibm.ut.ic.server.JettyServer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.server.WebappManager;

public class LocalServer {
    private int port = -1;
    private static LocalServer instance;
    private JettyServer server;

    private LocalServer() {
    }

    public static LocalServer getInstance() {
        if (instance == null) {
            instance = new LocalServer();
        }
        return instance;
    }

    public int start(IProgressMonitor monitor) throws CoreException, MalformedURLException {
        if (this.isStarted()) {
            return this.getPort();
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            this.port = this.getServerPort();
            monitor.worked(10);
        }
        catch (AlreadyBoundException e) {
            this.port = e.getPort();
            return this.port;
        }
        if (Platform.getBundle((String)"org.eclipse.jetty.webapp") != null) {
            this.server = new JettyServer("org.eclipse.jetty.webapp");
        } else if (Platform.getBundle((String)"org.mortbay.jetty.server") != null) {
            this.server = new JettyServer("org.mortbay.jetty.server");
        } else {
            Activator.logError("Jetty plugins are unavailable, could not start local server.", null);
            return -1;
        }
        File war = LocalHelp.getFile();
        File work = LocalHelp.getWorkFolder();
        try {
            this.server.deploy(war, work, this.port, monitor);
        }
        catch (Exception e) {
            Activator.logError("Unable to deploy jetty server.", e);
            return -1;
        }
        this.port = this.server.getPort();
        try {
            if (work != null) {
                File ideData = new File(work.getAbsolutePath() + "/eclipse/configuration/ide.ini");
                ideData.getParentFile().mkdirs();
                ideData.delete();
                ideData.createNewFile();
                PrintWriter pw = new PrintWriter(new FileWriter(ideData));
                BaseHelpSystem.ensureWebappRunning();
                pw.println("eclipse.helpURL=http://" + WebappManager.getHost() + ":" + WebappManager.getPort() + "/help");
                pw.flush();
                pw.close();
            }
        }
        catch (Exception exception) {}
        return this.port;
    }

    public boolean isStarted() {
        if (LocalHelp.getHelpMode() == 1) {
            return this.port != -1;
        }
        BaseHelpSystem.ensureWebappRunning();
        return true;
    }

    public int getPort() {
        return LocalHelp.getHelpMode() == 1 ? this.port : WebappManager.getPort();
    }

    public void stop() {
        if (this.isStarted() && this.server != null) {
            this.server.stop();
        }
        this.port = -1;
    }

    private int getServerPort() throws AlreadyBoundException, MalformedURLException {
        int port = LocalHelp.getLocalIC().getPort();
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.ccl.help.preferenceharvester.harvester");
        String[] products = new String[configs.length];
        int c = 0;
        while (c < configs.length) {
            products[c] = configs[c].getAttribute("name");
            ++c;
        }
        while (LocalServer.isPortInUse(port)) {
            if (this.isPortUseable(port, products)) {
                throw new AlreadyBoundException(port);
            }
            ++port;
        }
        return port;
    }

    private boolean isPortUseable(int port, String[] products) {
        BufferedReader br = null;
        boolean[] checklist = new boolean[products.length];
        int c = 0;
        while (c < checklist.length) {
            checklist[c] = false;
            ++c;
        }
        try {
            try {
                String line;
                URL url = new URL("http://127.0.0.1:" + port + "/help/updater/config?op=SiteInfo&link=local");
                br = new BufferedReader(new InputStreamReader(url.openStream()));
                while ((line = br.readLine()) != null) {
                    int p = 0;
                    while (p < products.length) {
                        if (line.contains(products[p])) {
                            checklist[p] = true;
                        }
                        ++p;
                    }
                }
            }
            catch (Exception exception) {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (Exception exception2) {}
                return false;
            }
        }
        catch (Throwable throwable) {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (br != null) {
                br.close();
            }
        }
        catch (Exception exception) {}
        c = 0;
        while (c < checklist.length) {
            if (!checklist[c]) {
                return false;
            }
            ++c;
        }
        return true;
    }

    public static boolean isPortInUse(int requestedPort) {
        Socket socket = null;
        try {
            try {
                socket = new Socket();
                socket.bind(new InetSocketAddress(InetAddress.getByName("127.0.0.1"), requestedPort));
            }
            catch (IOException iOException) {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException2) {}
                }
                return true;
            }
        }
        catch (Throwable throwable) {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    public static State getState(String xid) {
        URL url = null;
        State state = null;
        try {
            url = new URL(LocalHelp.getLocalIC().getHref() + "/updater/state?xid=" + xid);
            InputStream in = URLUtil.getStream((URL)url);
            if (in != null) {
                state = new State(in);
            }
        }
        catch (Exception ex) {
            Activator.logWarning("Unable to connect to " + String.valueOf(url), ex);
        }
        return state;
    }

    public static void cancelOperation(String xid) {
        URL url = null;
        HttpURLConnection conn = null;
        try {
            url = new URL(LocalHelp.getLocalIC().getHref() + "/updater/cancel?xid=" + xid);
            conn = (HttpURLConnection)url.openConnection();
            conn.setReadTimeout(86400000);
            conn.getInputStream().close();
        }
        catch (Exception ex) {
            Activator.logError("Unable to cancel request.", ex);
        }
    }
}

