/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.web;

import com.ibm.ut.help.common.web.ProxyUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.core.runtime.Path;

public class URLUtil {
    public static URL handleRedirects(URL url) throws IOException {
        URLConnection conn = ProxyUtil.getConnection(url);
        conn.getInputStream();
        return conn.getURL();
    }

    public static URLConnection getConnection(URL url) throws IOException {
        return ProxyUtil.getConnection(url);
    }

    public static InputStream getStream(URL url) throws IOException {
        return URLUtil.getConnection(url).getInputStream();
    }

    public static InputStream postStream(URL url, Properties args) throws IOException {
        return URLUtil.postConnection(url, args).getInputStream();
    }

    public static URLConnection postConnection(URL url, Properties args) throws IOException {
        return URLUtil.postConnection(url, args, null);
    }

    public static URLConnection postConnection(URL url, Properties args, Properties reqHeaders) throws IOException {
        String key;
        Enumeration<Object> keys;
        URLConnection conn = ProxyUtil.getConnection(url);
        Object data = "";
        if (reqHeaders != null) {
            keys = reqHeaders.keys();
            while (keys.hasMoreElements()) {
                key = (String)keys.nextElement();
                conn.addRequestProperty(key, reqHeaders.getProperty(key));
            }
        }
        keys = args.keys();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            data = (String)data + "&" + URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(args.getProperty(key), "UTF-8");
        }
        if (((String)data).length() > 0) {
            data = ((String)data).substring(1);
        }
        conn.setDoOutput(true);
        OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());
        out.write((String)data);
        out.flush();
        out.close();
        return conn;
    }

    public static InputStream postStream(URL url, String body) throws IOException {
        URLConnection conn = ProxyUtil.getConnection(url);
        conn.setDoOutput(true);
        PrintWriter pw = new PrintWriter(conn.getOutputStream());
        pw.append(body);
        pw.flush();
        pw.close();
        return conn.getInputStream();
    }

    public static InputStream deleteStream(URL url) throws IOException {
        URLConnection conn = ProxyUtil.getConnection(url);
        conn.setDoOutput(true);
        ((HttpURLConnection)conn).setRequestMethod("DELETE");
        return conn.getInputStream();
    }

    public static InputStream putStream(URL url, String body) throws IOException {
        URLConnection conn = ProxyUtil.getConnection(url);
        conn.setDoOutput(true);
        ((HttpURLConnection)conn).setRequestMethod("PUT");
        PrintWriter pw = new PrintWriter(conn.getOutputStream());
        pw.append(body);
        pw.flush();
        pw.close();
        return conn.getInputStream();
    }

    public static String getBackpath(String path) {
        int num = new Path(path).segmentCount();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < num) {
            if (i > 0) {
                buf.append('/');
            }
            buf.append("..");
            ++i;
        }
        return buf.toString();
    }

    public static URLConnection getConnection(URL url, String username, String password) throws IOException {
        URLConnection c = url.openConnection();
        if (c instanceof HttpURLConnection) {
            HttpURLConnection con = (HttpURLConnection)c;
            String encoded = new String(Base64.encodeBase64((byte[])(username + ":" + password).getBytes()));
            con.setRequestProperty("Authorization", "Basic " + encoded);
            return con;
        }
        if (c instanceof HttpsURLConnection) {
            HttpsURLConnection con = (HttpsURLConnection)c;
            String encoded = new String(Base64.encodeBase64((byte[])(username + ":" + password).getBytes()));
            con.setRequestProperty("Authorization", "Basic " + encoded);
            return con;
        }
        return c;
    }

    public static InputStream getStream(URL url, String username, String password) throws IOException {
        return URLUtil.getConnection(url, username, password).getInputStream();
    }

    public static InputStream getStream(URI uri) throws IOException {
        if (uri.toString().startsWith("http")) {
            return URLUtil.getStream(uri.toURL());
        }
        return new FileInputStream(uri.toURL().getFile());
    }
}

