/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.web;

import com.ibm.ut.help.common.web.LocaleUtil;
import com.ibm.ut.help.common.web.ProxyUtil;
import com.ibm.ut.help.parser.json.JSONElement;
import com.ibm.ut.help.parser.json.JSONParser;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ProxyBypassService
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void init() throws ServletException {
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("application/json; charset=UTF-8");
        resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        resp.getWriter().println(ProxyUtil.serializeProxyBypassHostsJSON(LocaleUtil.getLocale(req)).toString());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            ServletInputStream body = req.getInputStream();
            JSONParser parser = new JSONParser();
            JSONElement json = parser.parse((InputStream)body);
            if (json == null) {
                resp.sendError(415);
                return;
            }
            ProxyUtil.setProxyBypassHost(json);
            resp.setHeader("location", req.getRequestURL().toString());
        }
        catch (IOException e) {
            resp.sendError(415, e.getLocalizedMessage());
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            ServletInputStream body = req.getInputStream();
            JSONParser parser = new JSONParser();
            JSONElement json = parser.parse((InputStream)body);
            if (json == null) {
                resp.sendError(415);
                return;
            }
            ProxyUtil.addProxyBypassHost(json);
            resp.setHeader("location", req.getRequestURL().toString());
        }
        catch (IOException e) {
            resp.sendError(415, e.getLocalizedMessage());
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String uri = req.getRequestURL().toString();
            String id = uri.substring(uri.indexOf("/com.ibm.ut.help.common.web.ProxyBypasses") + "/com.ibm.ut.help.common.web.ProxyBypasses".length());
            if (id.startsWith("/")) {
                id = id.substring(1);
            }
            if (id.equals("")) {
                resp.sendError(415);
                return;
            }
            if (id.contains("-")) {
                id = id.substring(0, id.indexOf("-"));
            }
            try {
                ProxyUtil.removeProxyBypassHost(Integer.parseInt(id));
            }
            catch (Exception exception) {
                ProxyUtil.removeProxyBypassHost(id);
            }
            resp.setHeader("location", uri.substring(0, uri.indexOf(id)));
        }
        catch (IOException e) {
            resp.sendError(415, e.getLocalizedMessage());
        }
    }
}

