/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.web;

import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.Platform;

public class LocaleUtil {
    public static Locale getLocale(HttpServletRequest req) {
        Object lang = req.getParameter("lang");
        if (lang != null) {
            if (((String)lang).length() >= 5) {
                lang = ((String)lang).substring(0, 2) + "_" + ((String)lang).substring(3, 5);
            } else if (((String)lang).length() >= 2) {
                lang = ((String)lang).substring(0, 2);
            }
            return new Locale((String)lang);
        }
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            String cookie = null;
            int c = 0;
            while (c < cookies.length) {
                if (cookies[c].getName().equals("lang")) {
                    cookie = cookies[c].getValue();
                }
                ++c;
            }
            if (cookie != null) {
                return new Locale(cookie);
            }
        }
        return req.getLocale();
    }

    public static Locale getPlatformLocale() {
        Locale locale = null;
        String nl = Platform.getNL();
        if (nl != null) {
            String[] nls = nl.split("_");
            if (nls.length == 1) {
                locale = new Locale(nls[0]);
            } else if (nls.length == 2) {
                locale = new Locale(nls[0], nls[1]);
            } else if (nls.length == 3) {
                locale = new Locale(nls[0], nls[1], nls[2]);
            }
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }
}

