/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.web;

import com.ibm.ut.help.common.Activator;
import com.ibm.ut.help.common.prefs.Preferences;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public class HTTPSUtil {
    private static String[] defaultContexts = new String[]{"SSL_TLSv2", "TLSv1.2", "TLSv1.1", "TLSv1", "SSL"};
    private static List<String> contexts = new ArrayList<String>();

    static {
        String[] userContexts = Preferences.get("com.ibm.ut.help.common", "sslcontexts").split(",");
        int u = 0;
        while (u < userContexts.length) {
            userContexts[u] = userContexts[u].trim();
            if (!userContexts[u].equals("")) {
                contexts.add(userContexts[u]);
            }
            ++u;
        }
        Collections.addAll(contexts, defaultContexts);
    }

    public static URLConnection getConnection(URL httpsURL, Proxy proxy) throws IOException {
        SSLSocketFactory factory = null;
        InputStream in = null;
        int c = 0;
        while (in == null && c < contexts.size()) {
            try {
                SSLContext sc = SSLContext.getInstance(contexts.get(c++));
                sc.init(null, null, new SecureRandom());
                HttpsURLConnection con = (HttpsURLConnection)httpsURL.openConnection(proxy);
                factory = sc.getSocketFactory();
                con.setSSLSocketFactory(factory);
                in = con.getInputStream();
            }
            catch (Exception e) {
                Activator.logWarning("SSLContext error: " + String.valueOf(httpsURL), e);
            }
        }
        return HTTPSUtil.followRedirects(httpsURL, proxy, factory);
    }

    private static URLConnection followRedirects(URL url, Proxy proxy, SSLSocketFactory factory) throws IOException {
        int code = 0;
        do {
            HttpsURLConnection c = (HttpsURLConnection)url.openConnection(proxy);
            if (factory != null) {
                c.setSSLSocketFactory(factory);
            }
            if ((code = c.getResponseCode()) != 301 && code != 302) continue;
            url = new URL(c.getHeaderField("Location"));
        } while ((code == 301 || code == 302) && url != null);
        return url == null ? null : url.openConnection(proxy);
    }
}

