/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.security;

import com.ibm.ut.help.common.security.AuthDetails;
import com.ibm.ut.help.common.security.AuthException;
import com.ibm.ut.help.common.security.IAuthenticator;
import java.util.Base64;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SessionAuthenticator {
    private static Hashtable<String, SessionAuthenticator> map = new Hashtable();
    protected String sessionName;
    protected Hashtable<String, AuthDetails> sessions = new Hashtable();
    private IAuthenticator authenticator;

    public static SessionAuthenticator getInstance(IAuthenticator authenticator) {
        SessionAuthenticator s = map.get(authenticator.getClass().getCanonicalName());
        if (s == null) {
            s = new SessionAuthenticator(authenticator, authenticator.getClass().getName());
            map.put(authenticator.getClass().getCanonicalName(), s);
        }
        return s;
    }

    private SessionAuthenticator(IAuthenticator authenticator, String sessionName) {
        this.authenticator = authenticator;
        this.sessionName = sessionName;
        Thread cleaner = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(3600000L);
                    }
                    catch (Exception exception) {}
                    SessionAuthenticator.this.cleanSessions();
                }
            }
        };
        cleaner.start();
    }

    protected void cleanSessions() {
        long time = new Date().getTime();
        Enumeration<String> keys = this.sessions.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Properties props = this.sessions.get(key);
            long tstamp = (Long)props.get("tstamp");
            if (time - tstamp <= 1800000L) continue;
            this.sessions.remove(key);
        }
    }

    public void removeToken(String key) {
        this.sessions.remove(key);
    }

    public void removeToken(HttpServletRequest req, HttpServletResponse resp) {
        Cookie[] cookies = req.getCookies();
        int c = 0;
        while (c < cookies.length) {
            if (cookies[c].getName().equals(this.sessionName)) {
                this.removeToken(cookies[c].getValue());
                break;
            }
            ++c;
        }
    }

    public AuthDetails authenticate(HttpServletRequest req, HttpServletResponse resp) throws AuthException {
        AuthDetails details = this.getAuthenticationDetails(req);
        if (details != null) {
            return details;
        }
        String[] creds = SessionAuthenticator.getCredentials(req);
        details = this.authenticator.authenticate(creds[0], creds[1]);
        if (details != null) {
            this.createToken(resp, details);
        }
        return details;
    }

    public boolean isAuthenticated(HttpServletRequest req) {
        return this.getAuthenticationDetails(req) != null;
    }

    public IAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public AuthDetails getAuthenticationDetails(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        int c = 0;
        while (c < cookies.length) {
            if (cookies[c].getName().equals(this.sessionName)) {
                return this.sessions.get(cookies[c].getValue());
            }
            ++c;
        }
        return null;
    }

    public static String[] getCredentials(HttpServletRequest req) {
        StringTokenizer st;
        String username = req.getParameter("user") != null ? req.getParameter("user") : "";
        String password = req.getParameter("password") != null ? req.getParameter("password") : "";
        String authHeader = req.getHeader("Authorization");
        if (authHeader != null && (st = new StringTokenizer(authHeader)).hasMoreTokens()) {
            String basic = st.nextToken();
            String userPass = "";
            if (basic.equalsIgnoreCase("Basic")) {
                String credentials = st.nextToken();
                try {
                    userPass = new String(Base64.getMimeDecoder().decode(credentials));
                }
                catch (Exception exception) {
                    return new String[]{username, password};
                }
                int p = userPass.indexOf(":");
                if (p != -1) {
                    username = userPass.substring(0, p);
                    password = userPass.substring(p + 1);
                }
            }
        }
        return new String[]{username, password};
    }

    public String createToken(HttpServletResponse resp, AuthDetails details) {
        String token = UUID.randomUUID().toString();
        Cookie cookie = new Cookie(this.sessionName, token);
        cookie.setMaxAge(-1);
        cookie.setPath("/help");
        resp.addCookie(cookie);
        details.put("tstamp", (Object)new Date().getTime());
        this.sessions.put(token, details);
        return token;
    }
}

