/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.io;

import com.ibm.ut.help.common.ITopicModifier;
import com.ibm.ut.help.common.prefs.Preferences;
import com.ibm.ut.help.parser.ITagHandler;
import com.ibm.ut.help.parser.TagElement;
import com.ibm.ut.help.parser.TagParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class MutableHTMLOutputStream
extends OutputStream
implements ITagHandler {
    public static final int BEFORE_START = 1;
    public static final int AFTER_START = 2;
    public static final int BEFORE_END = 3;
    public static final int AFTER_END = 4;
    private List insertList = new ArrayList();
    private String charset = "UTF-8";
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private ByteArrayOutputStream modifiedBuffer = new ByteArrayOutputStream();
    private OutputStream finalDestinationOutput;
    private TagParser parser;
    private ITopicModifier modifier;

    public MutableHTMLOutputStream(OutputStream out) {
        this(out, null);
    }

    public MutableHTMLOutputStream(OutputStream out, ITopicModifier modifier) {
        this.finalDestinationOutput = out;
        this.modifier = modifier;
        this.parser = new TagParser();
        this.parser.setSelfCorrecting(false);
    }

    public TagParser getParser() {
        return this.parser;
    }

    @Override
    public void close() throws IOException {
        this.parser.setCharset(this.charset);
        TagElement root = this.parser.parse((InputStream)new ByteArrayInputStream(this.buffer.toByteArray()), (ITagHandler)this);
        if (this.modifier.didModify()) {
            if (Preferences.get("com.ibm.ut.help.common", "DEBUG") != null && Preferences.get("com.ibm.ut.help.common", "DEBUG").equals("true")) {
                System.out.println("---");
                System.out.write(root.toString().getBytes(this.charset));
                System.out.println("---");
            }
            this.finalDestinationOutput.write(root.toString().getBytes(this.charset));
            this.finalDestinationOutput.flush();
        } else {
            if (Preferences.get("com.ibm.ut.help.common", "DEBUG") != null && Preferences.get("com.ibm.ut.help.common", "DEBUG").equals("true")) {
                System.out.println("---");
                System.out.write(this.buffer.toByteArray());
                System.out.println("---");
            }
            this.finalDestinationOutput.write(this.buffer.toByteArray());
            this.finalDestinationOutput.flush();
        }
        this.buffer.close();
        this.finalDestinationOutput.close();
    }

    public void startElement(TagElement element) {
        if (this.modifier != null) {
            this.modifier.startElement(element);
        }
    }

    public void endElement(TagElement element) {
        int i = 0;
        while (i < this.insertList.size()) {
            InsertableElement insertable = (InsertableElement)this.insertList.get(i);
            if (insertable.matches(element)) {
                switch (insertable.getLocation()) {
                    case 1: {
                        MutableHTMLOutputStream.addToStart(this.parser.getParentTag(), insertable.getInsert());
                        break;
                    }
                    case 3: {
                        element.addChild((Object)insertable.getInsert());
                        break;
                    }
                    case 2: {
                        MutableHTMLOutputStream.addToStart(element, insertable.getInsert());
                        break;
                    }
                    case 4: {
                        this.parser.getParentTag().addChild((Object)insertable.getInsert());
                    }
                }
            }
            ++i;
        }
        if (this.modifier != null) {
            this.modifier.endElement(element);
        }
    }

    public void characters(TagElement element, String chars) {
        if (this.modifier != null) {
            this.modifier.characters(element, chars);
        }
    }

    public void comment(String chunk) {
        if (this.modifier != null) {
            this.modifier.comment(chunk);
        }
    }

    public static void addToStart(TagElement element, Object insert) {
        List children = element.getChildren();
        ArrayList<Object> newKids = new ArrayList<Object>();
        newKids.add(insert);
        int c = 0;
        while (c < children.size()) {
            newKids.add(children.get(c));
            ++c;
        }
        element.setChildren(newKids);
    }

    @Override
    public synchronized void flush() throws IOException {
    }

    public void insertText(TagElement toCompare, String toInsert, int location) {
        InsertableElement e = new InsertableElement(toInsert, toCompare, location);
        this.insertList.add(e);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.buffer.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.write(b);
    }

    private class InsertableElement {
        private String insert;
        private TagElement element;
        private int location;

        private InsertableElement(String insert, TagElement element, int location) {
            this.insert = insert;
            this.element = element;
            this.location = location;
        }

        public String getInsert() {
            return this.insert;
        }

        public TagElement getElement() {
            return this.element;
        }

        public int getLocation() {
            return this.location;
        }

        public boolean matches(TagElement candidate) {
            if (!this.element.getTag().equals(candidate.getTag())) {
                return false;
            }
            if (this.element.getProps() == null) {
                return true;
            }
            Enumeration<Object> keys = this.element.getProps().keys();
            while (keys.hasMoreElements()) {
                String name = (String)keys.nextElement();
                String val = this.element.getProps().getProperty(name);
                if (candidate.getProps().getProperty(name) == null) {
                    return false;
                }
                if (candidate.getProps().getProperty(name).contains(val)) continue;
                return false;
            }
            return true;
        }
    }
}

