/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class JarHandler {
    private static int BUFFER_SIZE = 4096;

    public static int writeNewJarOut(File directory, OutputStream out) throws IOException {
        JarOutputStream jarOut;
        File manifestFile = new File(directory, "META-INF" + File.separator + "MANIFEST.MF");
        if (manifestFile.exists()) {
            Manifest manifest = JarHandler.buildManifest(manifestFile);
            jarOut = new JarOutputStream(out, manifest);
        } else {
            jarOut = new JarOutputStream(out);
        }
        int contentLength = JarHandler.addJarEntry(directory.getAbsolutePath(), directory, jarOut);
        if (jarOut != null) {
            jarOut.close();
        }
        return contentLength;
    }

    private static int addJarEntry(String initialPath, File file, JarOutputStream out) throws IOException {
        int compressedLength = 0;
        if (file.getName().equalsIgnoreCase("MANIFEST.MF")) {
            String pkg = file.getAbsolutePath().substring(initialPath.length() + 1);
            ZipEntry entry = new ZipEntry(pkg);
            return (int)entry.getCompressedSize();
        }
        if (!file.isDirectory()) {
            FileInputStream in = new FileInputStream(file);
            String pkg = file.getAbsolutePath().substring(initialPath.length() + 1);
            ZipEntry entry = new ZipEntry(pkg);
            out.putNextEntry(entry);
            int read = 0;
            byte[] buffer = new byte[BUFFER_SIZE];
            while ((read = in.read(buffer)) > 0) {
                out.write(buffer, 0, read);
            }
            out.closeEntry();
            in.close();
            compressedLength = (int)entry.getCompressedSize();
        } else {
            File[] list = file.listFiles();
            int l = 0;
            while (l < list.length) {
                compressedLength += JarHandler.addJarEntry(initialPath, list[l], out);
                ++l;
            }
        }
        return compressedLength;
    }

    private static Manifest buildManifest(File man) throws IOException {
        FileInputStream fis = new FileInputStream(man);
        Manifest manifest = new Manifest(fis);
        ((InputStream)fis).close();
        return manifest;
    }

    public static void extractJar(File jar, File dest) {
        if (!dest.exists()) {
            dest.mkdirs();
        }
        try {
            JarFile jarFile = new JarFile(jar);
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry zip = e.nextElement();
                Object path = dest.getAbsolutePath() + "\\" + zip.getName();
                path = JarHandler.replaceAll((String)path, "/", "\\");
                File tmpDest = new File((String)path);
                if (zip.isDirectory()) {
                    tmpDest.mkdirs();
                    continue;
                }
                JarHandler.extractFromJar(jar, zip, tmpDest);
            }
        }
        catch (Exception exception) {}
    }

    public static void extractFromJar(File jarFile, ZipEntry entry, File dest) {
        try {
            int nBytes;
            JarFile jar = new JarFile(jarFile);
            BufferedInputStream in = new BufferedInputStream(jar.getInputStream(entry));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
            byte[] buffer = new byte[2048];
            while ((nBytes = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, nBytes);
            }
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            ((InputStream)in).close();
        }
        catch (Exception exception) {}
    }

    public static String replaceAll(String str, String find, String replace) {
        String[] split = ("START" + str + "END").split(find);
        StringBuffer buffer = new StringBuffer();
        int s = 0;
        while (s < split.length) {
            buffer.append(split[s]);
            buffer.append(replace);
            ++s;
        }
        return buffer.substring(5, buffer.length() - ("END" + replace).length());
    }
}

