/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.event;

import java.text.DecimalFormat;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProgressMonitor
implements IProgressMonitor {
    public static final int PRISTINE = 1;
    public static final int IN_USE = 2;
    public static final int FINISHED = 4;
    public static final int CANCELED = 8;
    public static final int MULTIPLIER = 1000;
    private String title = "";
    private String subTitle = "";
    private String xid = "";
    private boolean isCanceled = false;
    private boolean isFailed = false;
    private int totalWork = 0;
    private double worked = 0.0;
    private boolean usedUp = false;
    private int monitorState = 1;
    private int prevMonitorState = 0;
    private boolean indeterminate = false;
    private Throwable exception = null;
    private IProgressMonitor parent = null;
    private double parentWork = 0.0;
    private int parentTotal = 0;

    public ProgressMonitor(String xid) {
        this.xid = xid;
    }

    public ProgressMonitor(IProgressMonitor parent, int parentTotal) {
        this.parent = parent;
        this.parentTotal = parentTotal;
    }

    public void beginTask(String taskName, int totalWork) {
        if (this.parent != null) {
            this.parent.subTask(taskName);
        } else {
            this.title = taskName;
        }
        this.totalWork = totalWork;
        this.monitorState = 2;
    }

    public void continueTask(int totalWork) {
        this.totalWork = totalWork;
        this.monitorState = 2;
    }

    public void done() {
        this.indeterminate = false;
        if (this.monitorState == 4) {
            return;
        }
        double remaining = (double)this.totalWork - this.worked;
        if (remaining > 0.0) {
            this.internalWorked(remaining);
        }
        this.subTitle = "";
        this.monitorState = 4;
    }

    public void internalWorked(double work) {
        if (this.usedUp) {
            return;
        }
        if (this.parent != null) {
            double r = this.parentTotal;
            r *= work;
            if (this.parentWork + (r /= (double)this.totalWork) > (double)this.parentTotal) {
                this.parent.internalWorked((double)this.parentTotal - this.parentWork);
                this.usedUp = true;
            } else {
                this.parent.internalWorked(r);
                this.parentWork += r;
            }
        }
        this.worked += work;
        if (this.worked >= (double)this.totalWork) {
            this.usedUp = true;
            this.worked = this.totalWork;
            this.monitorState = 4;
        }
    }

    public boolean isCanceled() {
        if (this.parent != null) {
            return this.parent.isCanceled();
        }
        return this.isCanceled;
    }

    public void setCanceled(boolean value) {
        if (value) {
            this.prevMonitorState = this.monitorState;
            this.monitorState = 8;
            this.isCanceled = true;
        } else {
            this.monitorState = this.prevMonitorState;
            this.isCanceled = false;
        }
        if (this.parent != null) {
            this.parent.setCanceled(value);
        }
    }

    public void setIndeterminate(boolean val) {
        if (this.parent != null && this.parent instanceof ProgressMonitor) {
            ((ProgressMonitor)this.parent).setIndeterminate(val);
        }
        this.indeterminate = val;
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    public void throwException(Throwable e) {
        this.exception = e;
    }

    public Throwable exceptionThrown() {
        return this.exception;
    }

    public void setTaskName(String taskName) {
        if (this.parent != null) {
            this.parent.setTaskName(taskName);
        }
        this.title = taskName;
    }

    public void subTask(String subTaskName) {
        if (this.parent != null) {
            this.parent.subTask(subTaskName);
        }
        this.subTitle = subTaskName;
    }

    public void worked(int work) {
        this.internalWorked(work);
    }

    public String getXid() {
        return this.xid;
    }

    public int getProgressPercent() {
        if (this.parent != null) {
            return ((ProgressMonitor)this.parent).getProgressPercent();
        }
        if (this.isTaskFinished()) {
            return 100;
        }
        double fraction = this.worked / (double)this.totalWork;
        return (int)(fraction * 100.0);
    }

    public String getSubtitle() {
        return this.subTitle;
    }

    public String getTitle() {
        return this.title;
    }

    public int getMonitorState() {
        return this.monitorState;
    }

    public boolean isTaskFinished() {
        return this.monitorState == 4;
    }

    public boolean isTaskStarted() {
        return this.monitorState != 1;
    }

    public boolean isCancellationInProgress() {
        return this.monitorState == 8;
    }

    public boolean isFailed() {
        return this.isFailed;
    }

    public void setFailed(boolean isFailed) {
        this.isFailed = isFailed;
    }

    public String summary() {
        String res = this.getTitle() + " (" + this.worked + " / " + this.totalWork + ")";
        if (this.parent == null) {
            return res;
        }
        ProgressMonitor parent = this;
        while (parent.parent != null) {
            parent = (ProgressMonitor)parent.parent;
        }
        res = res + " " + parent.summary();
        return res;
    }

    public String toString() {
        if (this.parent == null) {
            DecimalFormat df = new DecimalFormat("#.##");
            return this.getTitle() + (String)(!this.subTitle.equals("") ? ": " + this.subTitle : "") + " (" + df.format(this.worked) + " / " + this.totalWork + ")";
        }
        return this.parent.toString();
    }

    public IProgressMonitor getParent() {
        return this.getParent(this);
    }

    private IProgressMonitor getParent(IProgressMonitor mon) {
        if (!(mon instanceof ProgressMonitor)) {
            return mon;
        }
        if (((ProgressMonitor)mon).parent == null) {
            return mon;
        }
        return this.getParent(((ProgressMonitor)mon).parent);
    }
}

