/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common.contentfilter.impl;

import com.ibm.ut.help.common.ITopicModifier;
import com.ibm.ut.help.common.io.MutableHTMLOutputStream;
import com.ibm.ut.help.common.prefs.Preferences;
import com.ibm.ut.help.parser.ITagHandler;
import com.ibm.ut.help.parser.TagAdapter;
import com.ibm.ut.help.parser.TagElement;
import com.ibm.ut.help.parser.TagParser;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.webapp.IFilter;

public abstract class TopicModifierContentFilter
implements IFilter {
    private ArrayList validTopics = new ArrayList();
    private ArrayList invalidTopics = new ArrayList();
    private IConfigurationElement[] configs;

    public IConfigurationElement[] loadConfigs() {
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.ut.help.common.topicModifier");
        Arrays.sort(configs, new TopicModifierComparator());
        return configs;
    }

    public OutputStream filter(HttpServletRequest req, OutputStream out) {
        if (this.configs == null) {
            this.configs = this.loadConfigs();
        }
        if (this.configs.length == 0 || Preferences.get("com.ibm.ut.help.common", "modifiers").equals("false")) {
            return out;
        }
        boolean modified = false;
        ModifierTagHandler handler = new ModifierTagHandler();
        int c = 0;
        while (c < this.configs.length) {
            try {
                ITopicModifier modifier = (ITopicModifier)this.configs[c].createExecutableExtension("class");
                if (modifier.isEnabled() && modifier.shouldModify(req) && this.isValidTopic(req)) {
                    modified = true;
                    handler.addModifier(modifier);
                }
            }
            catch (CoreException coreException) {}
            ++c;
        }
        if (!modified) {
            return out;
        }
        MutableHTMLOutputStream mutableOut = new MutableHTMLOutputStream(out, handler);
        List handlers = handler.getModifiers();
        int h = 0;
        while (h < handlers.size()) {
            ((ITopicModifier)handlers.get(h)).setParser(mutableOut.getParser());
            ++h;
        }
        return mutableOut;
    }

    private boolean isValidTopic(HttpServletRequest req) {
        String href;
        block9: {
            InputStream in;
            ValidationParser p;
            block8: {
                href = this.formatTopic(req.getRequestURI());
                if (href.contains("/nav/")) {
                    return true;
                }
                String referer = this.formatTopic(req.getHeader("Referer") != null ? req.getHeader("Referer") : "");
                if (this.invalidTopics.contains(href) || this.invalidTopics.contains(referer)) {
                    return false;
                }
                if (this.validTopics.contains(href)) {
                    return true;
                }
                if (!href.contains(".htm") && !href.contains(".html") && !href.contains(".xml") || href.contains("banner")) {
                    this.invalidTopics.add(href);
                    return false;
                }
                p = new ValidationParser();
                try {
                    in = HelpSystem.getHelpContent((String)href);
                    if (in != null) break block8;
                    return false;
                }
                catch (Exception exception) {
                    this.invalidTopics.add(href);
                    return false;
                }
            }
            p.parse(in);
            if (!p.isValid()) break block9;
            this.validTopics.add(href);
            return true;
        }
        this.invalidTopics.add(href);
        return false;
    }

    private String formatTopic(String href) {
        if (href.contains("/topic/")) {
            href = href.substring(href.indexOf("/topic/") + "/topic".length());
        }
        if (href.contains("/nftopic/")) {
            href = href.substring(href.indexOf("/nftopic/") + "/nftopic".length());
        }
        if (href.contains("/rtopic/")) {
            href = href.substring(href.indexOf("/rtopic/") + "/rtopic".length());
        }
        return href;
    }

    private class ModifierTagHandler
    implements ITopicModifier {
        private List handlers = new ArrayList();

        private ModifierTagHandler() {
        }

        public void addModifier(ITopicModifier handler) {
            this.handlers.add(handler);
        }

        public void startElement(TagElement element) {
            int h = 0;
            while (h < this.handlers.size()) {
                ((ITagHandler)this.handlers.get(h)).startElement(element);
                ++h;
            }
        }

        public void endElement(TagElement element) {
            int h = 0;
            while (h < this.handlers.size()) {
                ((ITagHandler)this.handlers.get(h)).endElement(element);
                ++h;
            }
        }

        public void characters(TagElement element, String chars) {
            int h = 0;
            while (h < this.handlers.size()) {
                ((ITagHandler)this.handlers.get(h)).characters(element, chars);
                ++h;
            }
        }

        public void comment(String chunk) {
            int h = 0;
            while (h < this.handlers.size()) {
                ((ITagHandler)this.handlers.get(h)).comment(chunk);
                ++h;
            }
        }

        public List getModifiers() {
            return this.handlers;
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public boolean shouldModify(HttpServletRequest request) {
            return false;
        }

        @Override
        public boolean didModify() {
            int h = 0;
            while (h < this.handlers.size()) {
                if (((ITopicModifier)this.handlers.get(h)).didModify()) {
                    return true;
                }
                ++h;
            }
            return false;
        }

        @Override
        public void setParser(TagParser parser) {
        }
    }

    private class TopicModifierComparator
    implements Comparator {
        private TopicModifierComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            int i2;
            IConfigurationElement c1 = (IConfigurationElement)arg0;
            IConfigurationElement c2 = (IConfigurationElement)arg1;
            int i1 = this.getID(c1.getAttribute("class"));
            if (i1 == (i2 = this.getID(c2.getAttribute("class")))) {
                return 0;
            }
            if (i1 < i2) {
                return -1;
            }
            return 1;
        }

        public int getID(String name) {
            if (name.equalsIgnoreCase("com.ibm.ut.help.common.topic.modifiers.OnLoadTopicModifier")) {
                return 7;
            }
            if (name.equalsIgnoreCase("com.ibm.ut.help.common.topic.modifiers.FeedbackModifier")) {
                return 8;
            }
            if (name.equalsIgnoreCase("com.ibm.ut.help.common.topic.modifiers.FooterTopicModifier")) {
                return 9;
            }
            if (name.equalsIgnoreCase("com.ibm.ut.commenter.CommentTopicModifier")) {
                return 10;
            }
            return 0;
        }
    }

    private class ValidationParser
    extends TagAdapter {
        boolean valid = true;

        private ValidationParser() {
        }

        public void startElement(TagElement element) {
            if (element.getTag().equals("link") && element.getProperty("href").contains("roadmap.css")) {
                this.valid = false;
                this.parser.forceStop();
            }
            if (element.getTag().equalsIgnoreCase("meta") && element.getProperty("name").equals("GENERATOR")) {
                this.valid = false;
                this.parser.forceStop();
            }
        }

        public void endElement(TagElement element) {
            if (element.getTag().equals("head")) {
                this.parser.forceStop();
            }
        }

        public boolean isValid() {
            return this.valid;
        }
    }
}

