/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ut.help.common;

import com.ibm.ut.help.common.web.LocaleUtil;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageLibrary {
    private static final String BUNDLE_NAME = "com.ibm.ut.help.common.Messages";
    private static final String ERROR_BUNDLE_NAME = "com.ibm.ut.help.common.errors";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.ibm.ut.help.common.Messages", LocaleUtil.getPlatformLocale());

    private MessageLibrary() {
    }

    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + key + "!";
        }
    }

    public static String getString(String key, Locale locale) {
        try {
            String s = ResourceBundle.getBundle(BUNDLE_NAME, locale).getString(key);
            return s;
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + key + "!";
        }
    }

    public static String getError(String key, Locale locale) {
        try {
            return ResourceBundle.getBundle(ERROR_BUNDLE_NAME, locale).getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + key + "!";
        }
    }

    public static String getErrorFormat(String key, String format, Locale locale) {
        String result = MessageLibrary.getError(key, locale);
        if (!format.equalsIgnoreCase("")) {
            result = MessageFormat.format(result, format);
        }
        return result;
    }

    public static String printBundle(ResourceBundle resources, PrintWriter writer) throws UnsupportedEncodingException {
        String charset = "UTF-8";
        Enumeration<String> keys = resources.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String val = resources.getString(key);
            val = val.replaceAll("\"", "");
            val = val.replaceAll("\\\\", "/");
            if ((val = val.replaceAll("'", "")).startsWith("'")) {
                val = val.substring(1, val.length() - 1);
            }
            writer.append("var ");
            writer.append(key);
            writer.append("_msg = '");
            writer.append(val);
            writer.append("';\n");
        }
        writer.append("var LANG = '");
        writer.append(resources.getLocale().toString());
        writer.append("';\n");
        return charset;
    }
}

