/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.genpassword.utils;

import com.ibm.debug.pdt.internal.genpassword.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Properties;
import javax.crypto.spec.PBEKeySpec;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.osgi.util.NLS;

public class Decryptor {
    static boolean isZos() {
        return "z/OS".equalsIgnoreCase(System.getProperty("os.name"));
    }

    public static Boolean isEncrypted(Properties p) {
        if (p.get("com.ibm.debug.pdt.genpassword.version") != null) {
            return true;
        }
        return false;
    }

    public static void checkKeystoreFileEncoding(String filename) throws DecryptorException {
        Properties p = new Properties();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(filename), StandardCharsets.UTF_8.name());){
                p.load(reader);
                if (p.size() < 2) {
                    throw new DecryptorException(Messages.CRRDG9414);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void checkKeystoreFileEncoding(Properties p) throws DecryptorException {
        if (p.size() < 2) {
            throw new DecryptorException(Messages.CRRDG9414);
        }
    }

    private static void validateFile(File file) throws DecryptorException {
        if (file.exists() && file.isFile()) {
            if (!file.canWrite()) {
                throw new DecryptorException(NLS.bind((String)Messages.CRRDG9405, (Object)file.getPath()));
            }
            if (!file.getName().endsWith(".properties")) {
                throw new DecryptorException(NLS.bind((String)Messages.CRRDG9407, (Object)file.getPath()));
            }
            return;
        }
        throw new DecryptorException(NLS.bind((String)Messages.CRRDG9416, (Object)file.getPath()));
    }

    public static final char[] decryptEncryptedPwd(String propertiesFile, String propertyKey) throws DecryptorException {
        Decryptor.checkKeystoreFileEncoding(propertiesFile);
        File keystoreFile = new File(propertiesFile);
        Decryptor.validateFile(keystoreFile);
        try {
            HashMap<String, PBEKeySpec> options = new HashMap<String, PBEKeySpec>();
            options.put("org.eclipse.equinox.security.storage.defaultPassword", new PBEKeySpec(Base64.getEncoder().encodeToString("com.ibm.debug.pdt.internal.genpassword.Generator".getBytes(Charset.defaultCharset())).toCharArray()));
            ISecurePreferences securePreferences = SecurePreferencesFactory.open((URL)keystoreFile.toURI().toURL(), options);
            char[] pwd = securePreferences.get(propertyKey, null).toCharArray();
            if (pwd == null || pwd.length == 0) {
                throw new DecryptorException(Messages.CRRDG9414);
            }
            return pwd;
        }
        catch (IOException | StorageException e) {
            throw new DecryptorException(Messages.CRRDG9414, (Exception)e);
        }
    }

    public static class DecryptorException
    extends Exception {
        private static final long serialVersionUID = 5170155690134680567L;

        public DecryptorException(String message) {
            super(message);
        }

        public DecryptorException(String message, Exception ex) {
            super(message, ex);
        }
    }
}

