/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.genpassword;

import com.ibm.debug.pdt.internal.genpassword.GeneratorParams;
import com.ibm.debug.pdt.internal.genpassword.Labels;
import com.ibm.debug.pdt.internal.genpassword.Messages;

public interface IGeneratorCoreConstants {
    public static final String KEYSTORE_INFO_FILE_VERSION = "1";
    public static final String PARAM_TOOL = "tool";
    public static final String PARAM_FILENAME = "filename";
    public static final String PARAM_ENCODING = "encoding";
    public static final String PARAM_VERSION = "version";
    public static final String PARAM_HELP = "help";
    public static final String CCS_TOOL = "ccs";
    public static final String RDS_TOOL = "rds";
    public static final String CCDAEMON_TOOL = "ccdaemon";
    public static final String RECDPS_TOOL = "recdps";
    public static final String RECDPSKEYSTORE_TOOL = "recdpskeystore";
    public static final String ACCEPTED_TOOL_VALUES = "ccs|rds|ccdaemon|recdps|recdpskeystore";
    public static final String PROPERTIES_FILE_FORMAT = ".properties";
    public static final String CP_IBM_1047 = "IBM-1047";
    public static final String PROPERTIES_KEY_VERSION = "com.ibm.debug.pdt.genpassword.version";
    public static final String SECURE_PREF_KEY_VERSION = "org.eclipse.equinox.security.preferences.version";
    public static final String SECURE_PREF_KEY_CIPHER = "org.eclipse.equinox.security.preferences.cipher";
    public static final String SECURE_PREF_KEY_KEYFACTORY = "org.eclipse.equinox.security.preferences.keyFactory";

    public static class Argument {
        private String fName;
        private VALUE_OPTION fValueOption;
        private boolean fInternal = false;

        public Argument() {
            this.fName = "";
            this.fValueOption = VALUE_OPTION.VALUE_NOT_REQUIRED;
        }

        public Argument(String name, VALUE_OPTION valueOption) {
            this.fName = name;
            if (this.fName.length() == 1) {
                this.fName = GeneratorParams.getLongParmName(this.fName);
            }
            this.fValueOption = valueOption;
        }

        public Argument(String name) {
            this.fName = name;
            this.fInternal = true;
            this.fValueOption = VALUE_OPTION.VALUE_REQUIRED;
        }

        public boolean isRequired() {
            return this.fValueOption.equals((Object)VALUE_OPTION.VALUE_REQUIRED);
        }

        public boolean isOptional() {
            return this.fValueOption.equals((Object)VALUE_OPTION.VALUE_OPTIONAL);
        }

        public boolean isNotRequired() {
            return this.fValueOption.equals((Object)VALUE_OPTION.VALUE_NOT_REQUIRED);
        }

        public String getName() {
            return this.fName;
        }

        public boolean isInternal() {
            return this.fInternal;
        }
    }

    public static enum Tool {
        RDS(Labels.RDS, null, "keystorePass", Messages.CRRDG9412),
        CCS(Labels.CCS, "ccskeystorefile", "ccskeystorepassword", Messages.CRRDG9411),
        CCDAEMON(Labels.CCDAEMON, "keystorefile", "keystorepassword", Messages.CRRDG9411),
        RECDPS(Labels.REC, null, "dpsPassword", Messages.CRRDG9418),
        RECDPSKEYSTORE(Labels.REC, null, "dpsKeystorePass", Messages.CRRDG9419);

        public final String toolName;
        public final String keystoreFileKey;
        public final String keystorePwdKey;
        public final String successMsg;

        private Tool(String toolName, String keystoreFileKey, String keystorePwdKey, String successMsg) {
            this.toolName = toolName;
            this.keystoreFileKey = keystoreFileKey;
            this.keystorePwdKey = keystorePwdKey;
            this.successMsg = successMsg;
        }
    }

    public static enum VALUE_OPTION {
        VALUE_NOT_REQUIRED,
        VALUE_REQUIRED,
        VALUE_OPTIONAL;

    }
}

