/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.genpassword;

import com.ibm.debug.pdt.internal.genpassword.Generator;
import com.ibm.debug.pdt.internal.genpassword.GeneratorUtils;
import com.ibm.debug.pdt.internal.genpassword.IGeneratorCoreConstants;
import com.ibm.debug.pdt.internal.genpassword.Messages;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.osgi.util.NLS;

public class GeneratorParams
extends Properties
implements IGeneratorCoreConstants {
    private static final long serialVersionUID = 5111939270194136038L;
    static final String SEPARATOR = System.getProperty("line.separator");
    private static Properties fParmProperties = null;
    private static Properties fKeystoreProperties = new Properties();
    private static final IGeneratorCoreConstants.Argument[] COMMAND_ARGUMENTS = new IGeneratorCoreConstants.Argument[]{new IGeneratorCoreConstants.Argument("tool", IGeneratorCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new IGeneratorCoreConstants.Argument("filename", IGeneratorCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new IGeneratorCoreConstants.Argument("encoding", IGeneratorCoreConstants.VALUE_OPTION.VALUE_REQUIRED), new IGeneratorCoreConstants.Argument("version", IGeneratorCoreConstants.VALUE_OPTION.VALUE_NOT_REQUIRED), new IGeneratorCoreConstants.Argument("help", IGeneratorCoreConstants.VALUE_OPTION.VALUE_NOT_REQUIRED)};

    public static GeneratorParams parse(String[] args) throws GeneratorException {
        GeneratorParams params = new GeneratorParams();
        CharArrayWriter cw = new CharArrayWriter();
        try {
            int i = 0;
            while (i < args.length) {
                String arg = args[i];
                if (arg.startsWith("-")) {
                    arg = arg.replace("\\", "\\\\");
                    cw.write(arg);
                    cw.write(SEPARATOR);
                }
                ++i;
            }
            params.load(new CharArrayReader(cw.toCharArray()));
        }
        catch (IOException e) {
            throw new GeneratorException(e.getMessage(), e);
        }
        return params;
    }

    public void printParms(OutputStream out) {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(out, Charset.defaultCharset()));
        Set<String> parms = this.stringPropertyNames();
        for (String parm : parms) {
            String value = this.getProperty(parm);
            pw.printf("%s=%s%n", parm, value.isEmpty() ? Boolean.valueOf(true) : value);
        }
        pw.flush();
    }

    private void validateArgumentValue(IGeneratorCoreConstants.Argument arg, String value) throws GeneratorException {
        if (arg.isInternal()) {
            return;
        }
        if (arg.isRequired() && (value == null || value.isEmpty())) {
            throw new GeneratorException(NLS.bind((String)Messages.CRRDG9400, (Object)arg.getName()));
        }
    }

    public void validateFile(String argument, String value) throws GeneratorException {
        File file = new File(value);
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException e) {
            GeneratorUtils.log(e);
            throw new GeneratorException(NLS.bind((String)Messages.CRRDG9401, (Object)argument, (Object)value));
        }
        if (this.reuseExistingPropertiesFile()) {
            if (!file.exists() || !file.isFile()) {
                throw new GeneratorException(NLS.bind((String)Messages.CRRDG9401, (Object)argument, (Object)value));
            }
            if (!file.canWrite()) {
                throw new GeneratorException(NLS.bind((String)Messages.CRRDG9405, (Object)value));
            }
            this.validatePropertiesFileFormat(file);
        } else {
            GeneratorParams.validateFolder(argument, file.getParent());
            this.validatePropertiesFileFormat(file);
        }
    }

    public static void validateFolder(String argument, String value) throws GeneratorException {
        File file = new File(value);
        if (file.exists() && file.isDirectory()) {
            if (!file.canWrite()) {
                throw new GeneratorException(NLS.bind((String)Messages.CRRDG9405, (Object)value));
            }
            return;
        }
        throw new GeneratorException(NLS.bind((String)Messages.CRRDG9401, (Object)argument, (Object)value));
    }

    private static void validateTool(String argument, String value) throws GeneratorException {
        String acceptedTools = "ccs|rds|ccdaemon|recdps|recdpskeystore";
        if (value.toLowerCase().matches(acceptedTools)) {
            return;
        }
        throw new GeneratorException(NLS.bind((String)Messages.CRRDG9402, (Object)argument, (Object)value));
    }

    public void validateParams() throws GeneratorException {
        Enumeration<?> arguments = this.propertyNames();
        while (arguments.hasMoreElements()) {
            String arg = (String)arguments.nextElement();
            IGeneratorCoreConstants.Argument argument = GeneratorParams.getArgument(GeneratorParams.getLongParmName(arg.substring(1)));
            if (argument == null) {
                this.remove(arg);
                throw new GeneratorException(NLS.bind((String)Messages.CRRDG9403, (Object)arg));
            }
            String value = this.getProperty(arg);
            this.validateArgumentValue(argument, value);
            if (!arg.startsWith("-")) continue;
            this.remove(arg);
            this.setProperty(argument.getName(), value.trim());
        }
        this.validateRequiredParams();
    }

    public static IGeneratorCoreConstants.Argument getArgument(String argument) {
        IGeneratorCoreConstants.Argument[] argumentArray = COMMAND_ARGUMENTS;
        int n = COMMAND_ARGUMENTS.length;
        int n2 = 0;
        while (n2 < n) {
            IGeneratorCoreConstants.Argument arg = argumentArray[n2];
            if (argument.startsWith("-") ? arg.getName().equals(argument.substring(1)) : arg.getName().equals(argument)) {
                return arg;
            }
            ++n2;
        }
        return null;
    }

    public boolean reuseExistingPropertiesFile() {
        String tool = this.getProperty("tool");
        return tool.equals("ccdaemon") || tool.equals("ccs");
    }

    public IGeneratorCoreConstants.Tool getTool() {
        String tool = this.getProperty("tool");
        IGeneratorCoreConstants.Tool[] toolArray = IGeneratorCoreConstants.Tool.values();
        int n = toolArray.length;
        int n2 = 0;
        while (n2 < n) {
            IGeneratorCoreConstants.Tool t = toolArray[n2];
            if (t.name().equalsIgnoreCase(tool)) {
                return t;
            }
            ++n2;
        }
        return null;
    }

    public File getSecurePrefFile() throws GeneratorException {
        File securePrefFile = new File(this.getProperty("filename"));
        try {
            securePrefFile = securePrefFile.getCanonicalFile();
        }
        catch (IOException e) {
            GeneratorUtils.log(e);
            throw new GeneratorException(NLS.bind((String)Messages.CRRDG9401, (Object)"filename", (Object)this.getProperty("filename")));
        }
        if (!this.reuseExistingPropertiesFile() && securePrefFile.exists()) {
            System.out.println(NLS.bind((String)Messages.CRRDG9413, (Object)securePrefFile.getPath()));
            String newFilename = securePrefFile.getName().replace(".", "_" + System.currentTimeMillis() + ".");
            return new File(securePrefFile.getParent(), newFilename);
        }
        return securePrefFile;
    }

    public void loadKeystoreInfoProperties(File propertiesFile) throws GeneratorException {
        String codepage = this.getCodePage();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(propertiesFile), codepage);){
                fKeystoreProperties.load(reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            GeneratorUtils.log(e);
            throw new GeneratorException(NLS.bind((String)Messages.CRRDG9406, (Object)propertiesFile.getPath()));
        }
        if (fKeystoreProperties.getProperty(this.getTool().keystoreFileKey, "").isBlank()) {
            throw new GeneratorException(NLS.bind((String)Messages.CRRDG9417, (Object)propertiesFile.getPath()));
        }
    }

    public void setKeystoreInfoProperties(File propertiesFile) throws GeneratorException {
        String codepage = StandardCharsets.UTF_8.name();
        try {
            Throwable throwable = null;
            Object var4_8 = null;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(propertiesFile), codepage);){
                Properties pwdProp = new Properties();
                pwdProp.load(reader);
                Properties keystoreInfoProp = new Properties();
                if (fKeystoreProperties != null) {
                    keystoreInfoProp.putAll((Map<?, ?>)fKeystoreProperties);
                }
                keystoreInfoProp.putAll((Map<?, ?>)pwdProp);
                keystoreInfoProp.setProperty("com.ibm.debug.pdt.genpassword.version", "1");
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(propertiesFile), codepage);
                keystoreInfoProp.store(writer, String.join((CharSequence)System.lineSeparator(), Messages.DO_NOT_MODIFY, NLS.bind((String)Messages.JAVA_VERSION, (Object)Runtime.version().feature())));
                writer.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (UnsupportedEncodingException e) {
            GeneratorUtils.log(e);
            throw new GeneratorException(NLS.bind((String)Messages.CRRDG9408, (Object)codepage));
        }
        catch (Exception e) {
            GeneratorUtils.log(e);
            throw new GeneratorException(NLS.bind((String)Messages.CRRDG9406, (Object)propertiesFile.getPath()));
        }
        if (GeneratorParams.isZos()) {
            try {
                ProcessBuilder pb = new ProcessBuilder("chtag", "-c", codepage, propertiesFile.getPath());
                Process process = pb.start();
                process.waitFor(5L, TimeUnit.SECONDS);
            }
            catch (IOException | InterruptedException e) {
                System.out.println(Messages.CRRDG9420);
            }
        }
    }

    private void validatePropertiesFileFormat(File file) throws GeneratorException {
        if (file.getName().endsWith(".properties")) {
            return;
        }
        throw new GeneratorException(NLS.bind((String)Messages.CRRDG9407, (Object)file.getPath()));
    }

    private String getCodePage() {
        String codepage;
        String string = codepage = GeneratorParams.isZos() ? "IBM-1047" : Charset.defaultCharset().name();
        if (this.getProperty("encoding") != null) {
            codepage = this.getProperty("encoding");
        }
        return codepage;
    }

    public static String getHelpMessage() {
        if (GeneratorParams.isZos()) {
            return Messages.Product_Syntax + Messages.Product_Help_options + Messages.Product_Help_t_zos + Messages.Product_Help_f + Messages.Product_Help_f_zos_append + Messages.Product_Help_v + Messages.Product_Help_h;
        }
        return Messages.Product_Syntax + Messages.Product_Help_options + Messages.Product_Help_t + Messages.Product_Help_f + Messages.Product_Help_v + Messages.Product_Help_h;
    }

    private static synchronized void initParmSingleLetter() {
        if (fParmProperties == null) {
            fParmProperties = new Properties();
            try {
                Throwable throwable = null;
                Object var1_3 = null;
                try (InputStream stream = GeneratorParams.class.getResourceAsStream("parm.properties");){
                    fParmProperties.load(stream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                GeneratorUtils.log(e);
            }
        }
    }

    static synchronized String getLongParmName(String parm) {
        GeneratorParams.initParmSingleLetter();
        if (fParmProperties.containsKey(parm)) {
            return fParmProperties.getProperty(parm);
        }
        return parm;
    }

    static boolean isZos() {
        return "z/OS".equalsIgnoreCase(System.getProperty("os.name"));
    }

    public boolean isShowHelp() {
        return this.getProperty("help", false);
    }

    public boolean isShowVersion() {
        return this.getProperty("version", false);
    }

    @Override
    public synchronized void putAll(Map<? extends Object, ? extends Object> t) {
        if (t instanceof Properties) {
            Set<String> parms = ((Properties)t).stringPropertyNames();
            for (String string : parms) {
                this.put(string, ((Properties)t).getProperty(string));
            }
        } else {
            super.putAll(t);
        }
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        if (((String)key).charAt(0) == '-' && ((String)key).length() == 2) {
            key = "-" + GeneratorParams.getLongParmName(((String)key).substring(1));
        } else if (((String)key).length() == 1) {
            key = GeneratorParams.getLongParmName((String)key);
        }
        if (((String)key).equals("tool")) {
            value = value.toLowerCase();
        }
        return super.setProperty((String)key, value);
    }

    public synchronized boolean getProperty(String name, boolean defaultValue) {
        String property = this.getProperty(name);
        if (property == null) {
            return defaultValue;
        }
        if (property.isEmpty()) {
            return true;
        }
        return Boolean.parseBoolean(property);
    }

    private void validateRequiredParams() throws GeneratorException {
        if (!this.isShowHelp() && !this.isShowVersion()) {
            String tool = this.getProperty("tool");
            if (tool == null) {
                throw new GeneratorException(NLS.bind((String)Messages.CRRDG9409, (Object)"tool"));
            }
            GeneratorParams.validateTool("tool", tool);
            String filename = this.getProperty("filename");
            if (filename == null) {
                throw new GeneratorException(NLS.bind((String)Messages.CRRDG9409, (Object)"filename"));
            }
            this.validateFile("filename", filename);
        }
    }

    public String getProductVersion() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream stream = Generator.class.getResourceAsStream("version.properties");){
                Properties versionProperties = new Properties();
                versionProperties.load(stream);
                return versionProperties.getProperty("version");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            return "";
        }
    }

    public static class GeneratorException
    extends Exception {
        private static final long serialVersionUID = -2963994377265817449L;

        public GeneratorException(String message) {
            super(message);
        }

        public GeneratorException(String message, Exception ex) {
            super(message, ex);
        }
    }
}

