/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.genpassword;

import com.ibm.debug.pdt.internal.genpassword.GeneratorParams;
import com.ibm.debug.pdt.internal.genpassword.GeneratorUtils;
import com.ibm.debug.pdt.internal.genpassword.IGeneratorCoreConstants;
import com.ibm.debug.pdt.internal.genpassword.Messages;
import java.io.Console;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.PBEKeySpec;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.osgi.util.NLS;

public class Generator
implements IApplication {
    private static final String DEFAULT = Base64.getEncoder().encodeToString("com.ibm.debug.pdt.internal.genpassword.Generator".getBytes(Charset.defaultCharset()));
    private static ISecurePreferences fSecurePreferences;
    private static File fKeystorePasswordFile;
    private static Object fLockObject;
    private static GeneratorParams fParams;
    public static final Integer EXIT_ERROR;

    static {
        fLockObject = new Object();
        fParams = null;
        EXIT_ERROR = -1;
    }

    public Object start(IApplicationContext context) throws Exception {
        Map argMap = context.getArguments();
        String[] args = (String[])argMap.get("application.args");
        Generator.runGenpassword(args);
        return EXIT_OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int runGenpassword(String[] args) {
        String version;
        try {
            Object object = fLockObject;
            synchronized (object) {
                fParams = Generator.resolveParams(args);
            }
        }
        catch (GeneratorParams.GeneratorException e) {
            System.out.println(e.getMessage());
            System.out.println();
            System.out.println(GeneratorParams.getHelpMessage());
            return EXIT_ERROR;
        }
        if (fParams.isShowHelp()) {
            version = fParams.getProductVersion();
            System.out.println();
            System.out.println(Messages.Product_Name);
            System.out.println(NLS.bind((String)Messages.License_Description, (Object)version));
            System.out.println();
            System.out.println(GeneratorParams.getHelpMessage());
            return EXIT_OK;
        }
        if (fParams.isShowVersion()) {
            version = fParams.getProductVersion();
            System.out.println();
            System.out.println(Messages.Product_Name);
            System.out.println(NLS.bind((String)Messages.License_Description, (Object)version));
            return EXIT_OK;
        }
        int returnCode = EXIT_OK;
        try {
            Generator.generateEncryptedKeystorePassword();
        }
        catch (GeneratorParams.GeneratorException e) {
            System.out.println(e);
            returnCode = EXIT_ERROR;
        }
        if (returnCode == EXIT_OK) {
            System.out.println(NLS.bind((String)Generator.fParams.getTool().successMsg, (Object)fKeystorePasswordFile.getPath()));
            System.out.println(NLS.bind((String)Messages.CRRDG9415, (Object)fKeystorePasswordFile.getPath()));
        }
        return returnCode;
    }

    private static int generateEncryptedKeystorePassword() throws GeneratorParams.GeneratorException {
        fKeystorePasswordFile = fParams.getSecurePrefFile();
        if (fParams.reuseExistingPropertiesFile()) {
            fParams.loadKeystoreInfoProperties(fKeystorePasswordFile);
        }
        Generator.encryptKeystorePassword();
        fParams.setKeystoreInfoProperties(fKeystorePasswordFile);
        return EXIT_OK;
    }

    public static GeneratorParams resolveParams(String[] args) throws GeneratorParams.GeneratorException {
        GeneratorParams baseParms = new GeneratorParams();
        if (args.length <= 0) {
            throw new GeneratorParams.GeneratorException(NLS.bind((String)Messages.CRRDG9409, (Object)"tool"));
        }
        GeneratorParams cmdLineParms = GeneratorParams.parse(args);
        cmdLineParms.validateParams();
        baseParms.putAll(cmdLineParms);
        return baseParms;
    }

    private static void encryptKeystorePassword() throws GeneratorParams.GeneratorException {
        char[] password = null;
        Console console = System.console();
        if (console == null) {
            throw new GeneratorParams.GeneratorException(Messages.CRRDG9404);
        }
        password = console.readPassword(NLS.bind((String)Messages.PASSWORD_PROMPT, (Object)Generator.fParams.getTool().toolName), new Object[0]);
        if (password.length == 0) {
            throw new GeneratorParams.GeneratorException(Messages.CRRDG9410);
        }
        Generator.generateKeystorePasswordFile(fParams.getTool(), fKeystorePasswordFile, password);
    }

    public static void generateKeystorePasswordFile(IGeneratorCoreConstants.Tool tool, File securePrefFile, char[] password) throws GeneratorParams.GeneratorException {
        Generator.addPasswordToSecureStorage(tool, Generator.getSecurePreferences(securePrefFile), password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ISecurePreferences getSecurePreferences(File securePrefFile) throws GeneratorParams.GeneratorException {
        try {
            Object object = fLockObject;
            synchronized (object) {
                HashMap<String, PBEKeySpec> options = new HashMap<String, PBEKeySpec>();
                options.put("org.eclipse.equinox.security.storage.defaultPassword", new PBEKeySpec(DEFAULT.toCharArray()));
                URL url = new URL("file:////" + securePrefFile.toString());
                fSecurePreferences = SecurePreferencesFactory.open((URL)url, options);
            }
        }
        catch (Exception e) {
            GeneratorUtils.log(e);
            throw new GeneratorParams.GeneratorException(NLS.bind((String)Messages.CRRDG9406, (Object)fKeystorePasswordFile.getPath()), e);
        }
        return fSecurePreferences;
    }

    private static void addPasswordToSecureStorage(IGeneratorCoreConstants.Tool tool, ISecurePreferences securePreferences, char[] keyStorePassword) throws GeneratorParams.GeneratorException {
        try {
            securePreferences.clear();
            securePreferences.put(tool.keystorePwdKey, String.valueOf(keyStorePassword), true);
            securePreferences.flush();
        }
        catch (Exception e) {
            GeneratorUtils.log(e);
            throw new GeneratorParams.GeneratorException(NLS.bind((String)Messages.CRRDG9405, (Object)fKeystorePasswordFile.getPath()), e);
        }
    }

    public void stop() {
    }
}

