/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui;

import com.ibm.debug.pdt.core.breakpoints.GenericLineBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLLocationBreakpoint;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.LocationBreakpoint;
import com.ibm.debug.pdt.internal.core.model.StackFrame;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.model.ViewInformation;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.ui.EngineSuppliedViewEditorInput;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.ui.DebuggerMarkerAnnotation;
import com.ibm.debug.pdt.ui.PDTInstructionPointerAnnotation;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class DebuggerMarkerAnnotationModel
extends ResourceMarkerAnnotationModel
implements IBreakpointListener {
    protected String fFilename = null;
    protected IEditorInput fEditorInput = null;
    private Vector<PDTInstructionPointerAnnotation> fInstrPtrList = new Vector();
    private ResetMarkerJob fMarkerResetJob;

    public DebuggerMarkerAnnotationModel(IResource resource, IEditorInput input) {
        super(resource);
        this.fFilename = input.getName();
        this.fEditorInput = input;
        this.fMarkerResetJob = new ResetMarkerJob();
    }

    protected MarkerAnnotation createMarkerAnnotation(IMarker marker) {
        try {
            if (!marker.isSubtypeOf(IBreakpoint.BREAKPOINT_MARKER)) {
                return new MarkerAnnotation(marker);
            }
            return new DebuggerMarkerAnnotation(marker, this.fFilename);
        }
        catch (CoreException coreException) {
            return new MarkerAnnotation(marker);
        }
    }

    public void connect(IDocument document) {
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        super.connect(document);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Position createPositionFromMarker(IMarker marker) {
        if (this.fDocument == null) return null;
        if (marker == null) {
            return null;
        }
        try {
            if (!marker.isSubtypeOf(IBreakpoint.BREAKPOINT_MARKER)) {
                return super.createPositionFromMarker(marker);
            }
            IBreakpoint iBP = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker);
            int line = 0;
            if (PDTCoreUtils.isSourceLineBreakpoint((IBreakpoint)iBP) || PDTCoreUtils.isSourceEntryBreakpoint((IBreakpoint)iBP)) {
                if (!(this.fEditorInput instanceof EngineSuppliedViewEditorInput)) {
                    return super.createPositionFromMarker(marker);
                }
                EngineSuppliedViewEditorInput esv = (EngineSuppliedViewEditorInput)this.fEditorInput;
                PICLDebugTarget dbgtgt = esv.getPICLDebugTarget();
                if (dbgtgt == null) return null;
                if (dbgtgt.isTerminated()) {
                    return null;
                }
                Breakpoint modelBP = dbgtgt.getBreakpoint(marker);
                if (modelBP == null) return null;
                if (modelBP.isDeferred()) return null;
                if (!(modelBP instanceof LocationBreakpoint)) {
                    return null;
                }
                Location locationBP = ((LocationBreakpoint)modelBP).getLocationWithinView(esv.getViewFile().getView());
                if (locationBP == null) {
                    return null;
                }
                line = PICLUtils.getBufferedLineNumber((IEditorInput)esv, locationBP.getLineNumber());
            } else if (iBP instanceof PICLLocationBreakpoint) {
                PICLLocationBreakpoint piclBP = (PICLLocationBreakpoint)iBP;
                if (piclBP.isDeferred() && !piclBP.isImported()) {
                    return null;
                }
                if (!(this.fEditorInput instanceof EngineSuppliedViewEditorInput)) {
                    PDTDebugTarget dbgtgt = piclBP.getDebugTarget();
                    if (dbgtgt == null) return null;
                    if (dbgtgt.isTerminated()) {
                        return null;
                    }
                    ViewInformation sourceViewInfo = dbgtgt.getDebugEngine().getSourceViewInformation();
                    Location piclBPLocation = piclBP.getLocation(sourceViewInfo);
                    if (piclBPLocation == null) {
                        return null;
                    }
                    line = piclBPLocation.getLineNumber();
                } else {
                    EngineSuppliedViewEditorInput esv = (EngineSuppliedViewEditorInput)this.fEditorInput;
                    Location piclBPLocation = piclBP.getLocation(esv.getViewInformation());
                    if (piclBPLocation == null) {
                        return null;
                    }
                    line = PICLUtils.getBufferedLineNumber((IEditorInput)esv, piclBPLocation.getLineNumber());
                }
            }
            if (line <= 0) return null;
            int start = this.fDocument.getLineOffset(line - 1);
            if (start <= -1) return null;
            return new Position(start, 0);
        }
        catch (CoreException coreException) {
            return null;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    protected boolean isAcceptable(IMarker marker) {
        block19: {
            PICLLocationBreakpoint piclBP;
            block21: {
                block20: {
                    IBreakpoint iBP;
                    block16: {
                        Breakpoint modelBP;
                        EngineSuppliedViewEditorInput esv;
                        block18: {
                            PICLDebugTarget dbgtgt;
                            block17: {
                                block15: {
                                    if (marker == null) {
                                        return false;
                                    }
                                    if (!marker.isSubtypeOf(IBreakpoint.BREAKPOINT_MARKER)) {
                                        return super.isAcceptable(marker);
                                    }
                                    if (!PICLDebugPlugin.isShuttingDown()) break block15;
                                    return false;
                                }
                                iBP = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker);
                                if (!PDTCoreUtils.isSourceLineBreakpoint((IBreakpoint)iBP) && !PDTCoreUtils.isSourceEntryBreakpoint((IBreakpoint)iBP)) break block16;
                                if (!(this.fEditorInput instanceof EngineSuppliedViewEditorInput)) {
                                    return super.isAcceptable(marker);
                                }
                                esv = (EngineSuppliedViewEditorInput)this.fEditorInput;
                                dbgtgt = esv.getPICLDebugTarget();
                                if (dbgtgt != null && !dbgtgt.isTerminated()) break block17;
                                return false;
                            }
                            modelBP = dbgtgt.getBreakpoint(marker);
                            if (modelBP != null && !modelBP.isDeferred() && modelBP instanceof LocationBreakpoint) break block18;
                            return false;
                        }
                        ViewFile inputViewFile = esv.getViewFile();
                        if (inputViewFile.hasBreakpoint(modelBP)) {
                            return true;
                        }
                    }
                    if (!(iBP instanceof PICLLocationBreakpoint)) break block19;
                    piclBP = (PICLLocationBreakpoint)iBP;
                    if (!piclBP.isDeferred() || piclBP.isImported()) break block20;
                    return false;
                }
                if (this.fEditorInput instanceof EngineSuppliedViewEditorInput) break block21;
                String BPfileName = ((LocationBreakpoint)piclBP.getModelBreakpoint()).getFileName();
                ViewFile viewFile = PICLUtils.getViewFile(this.fEditorInput);
                if (BPfileName != null && BPfileName.equalsIgnoreCase(viewFile.getFileName())) {
                    return true;
                }
            }
            try {
                ViewFile inputViewFile = ((EngineSuppliedViewEditorInput)this.fEditorInput).getViewFile();
                if (inputViewFile.hasBreakpoint(piclBP.getModelBreakpoint())) {
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    protected IMarker[] retrieveMarkers() throws CoreException {
        return ResourcesPlugin.getWorkspace().getRoot().findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2);
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (breakpoint instanceof PICLLocationBreakpoint || breakpoint instanceof GenericLineBreakpoint) {
            this.resetMarkers();
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (breakpoint instanceof PICLLocationBreakpoint || breakpoint instanceof GenericLineBreakpoint) {
            this.resetMarkers();
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (breakpoint instanceof PICLLocationBreakpoint || breakpoint instanceof GenericLineBreakpoint) {
            this.resetMarkers();
        }
    }

    private void submitResetMarkerJob() {
        Job.getJobManager().cancel((Object)this.fMarkerResetJob);
        this.fMarkerResetJob.schedule();
    }

    public void resetMarkers() {
        this.submitResetMarkerJob();
    }

    public void addAnnotation(Annotation annotation, Position position) {
        if (annotation instanceof PDTInstructionPointerAnnotation) {
            StackFrame frame = (StackFrame)((PDTInstructionPointerAnnotation)annotation).getStackFrame();
            try {
                int line = frame.getLineNumber();
                line = PICLUtils.getBufferedLineNumber(this.fEditorInput, line);
                int start = 0;
                if (line > 0 && this.fDocument != null) {
                    start = this.fDocument.getLineOffset(line - 1);
                }
                if (start > -1) {
                    position = new Position(start, 0);
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (BadLocationException badLocationException) {
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
        if (position != null) {
            super.addAnnotation(annotation, position);
        } else if (annotation instanceof PDTInstructionPointerAnnotation) {
            this.getAnnotationMap().put((Object)annotation, (Object)position);
        }
    }

    public void addInstructionPointerAnnotation(StackFrame frame) {
        IThread currentThread = frame.getThread();
        Iterator<PDTInstructionPointerAnnotation> iter = this.fInstrPtrList.iterator();
        PDTInstructionPointerAnnotation instrPtr = null;
        while (iter.hasNext()) {
            instrPtr = iter.next();
            if (instrPtr == null || instrPtr.getStackFrame().getThread() == currentThread) continue;
            iter.remove();
            this.removeAnnotation(instrPtr, false);
        }
        instrPtr = new PDTInstructionPointerAnnotation(frame);
        this.fInstrPtrList.add(instrPtr);
        this.addAnnotation(instrPtr, null);
        this.fireModelChanged();
    }

    public void removeInstructionPointerAnnotations(DebuggeeThread thread) {
        if (thread == null) {
            return;
        }
        Iterator<PDTInstructionPointerAnnotation> iter = this.fInstrPtrList.iterator();
        PDTInstructionPointerAnnotation instrPtr = null;
        while (iter.hasNext()) {
            instrPtr = iter.next();
            if (instrPtr == null || instrPtr.getStackFrame().getThread() != thread) continue;
            iter.remove();
            this.removeAnnotation(instrPtr, false);
        }
        this.fireModelChanged();
    }

    protected void disconnected() {
        super.disconnected();
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        this.fInstrPtrList.clear();
    }

    protected void removeAnnotation(final Annotation annotation, final boolean fireModelChanged) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                DebuggerMarkerAnnotationModel.this.removeAnnotationInternal(annotation, fireModelChanged);
            }
        });
    }

    private void removeAnnotationInternal(Annotation annotation, boolean fireModelChanged) {
        super.removeAnnotation(annotation, fireModelChanged);
    }

    protected void addAnnotation(final Annotation annotation, final Position position, final boolean fireModelChanged) throws BadLocationException {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    DebuggerMarkerAnnotationModel.this.addAnnotationInternal(annotation, position, fireModelChanged);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
    }

    private void addAnnotationInternal(Annotation annotation, Position position, boolean fireModelChanged) throws BadLocationException {
        super.addAnnotation(annotation, position, fireModelChanged);
    }

    private class ResetMarkerJob
    extends UIJob {
        public ResetMarkerJob() {
            super("Reset markers");
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            int n;
            int n2;
            Object[] objectArray;
            Iterator iter = DebuggerMarkerAnnotationModel.this.getAnnotationIterator();
            while (iter.hasNext()) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Object element = iter.next();
                if (!(element instanceof DebuggerMarkerAnnotation)) continue;
                DebuggerMarkerAnnotationModel.this.removeAnnotation((Annotation)element, false);
            }
            try {
                IMarker[] markers;
                objectArray = markers = DebuggerMarkerAnnotationModel.this.retrieveMarkers();
                n2 = markers.length;
                n = 0;
                while (n < n2) {
                    IMarker marker = objectArray[n];
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    DebuggerMarkerAnnotationModel.this.addMarkerAnnotation(marker);
                    ++n;
                }
            }
            catch (CoreException markers) {
                // empty catch block
            }
            PDTInstructionPointerAnnotation[] exisitngInstrPtrs = DebuggerMarkerAnnotationModel.this.fInstrPtrList.toArray(new PDTInstructionPointerAnnotation[DebuggerMarkerAnnotationModel.this.fInstrPtrList.size()]);
            objectArray = exisitngInstrPtrs;
            n2 = exisitngInstrPtrs.length;
            n = 0;
            while (n < n2) {
                IMarker ptrAnnotation = objectArray[n];
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                DebuggerMarkerAnnotationModel.this.removeAnnotation((Annotation)ptrAnnotation, false);
                DebuggerMarkerAnnotationModel.this.addAnnotation((Annotation)ptrAnnotation, null);
                ++n;
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            DebuggerMarkerAnnotationModel.this.fireModelChanged();
            return Status.OK_STATUS;
        }
    }
}

