/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.views;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.DebugEngineCommandLogResponseEvent;
import com.ibm.debug.pdt.internal.core.model.DebugEngineEventAdapter;
import com.ibm.debug.pdt.internal.core.model.DebugEngineTerminatedEvent;
import com.ibm.debug.pdt.internal.core.model.IDebugEngineEventListener;
import com.ibm.debug.pdt.internal.core.model.IModelEventListener;
import com.ibm.debug.pdt.internal.core.model.ModelStateReadyEvent;
import com.ibm.debug.pdt.internal.ui.util.DebugConsoleUtils;
import com.ibm.debug.pdt.internal.ui.util.LogLine;
import java.util.ArrayList;

public class DebugConsoleSession
extends DebugEngineEventAdapter {
    private static final String[] EMPTYHISTORY = new String[0];
    private PDTDebugTarget fDebugTarget;
    private ArrayList<String> fCommandHistory = new ArrayList();
    private ArrayList<LogLine> fLogLines = new ArrayList();
    private String[] fCommandFieldHistory = EMPTYHISTORY;
    private boolean fSupportsLog = false;

    public DebugConsoleSession(PDTDebugTarget newTarget) {
        this.fDebugTarget = newTarget;
        this.fDebugTarget.getDebugEngine().addEventListener((IDebugEngineEventListener)this);
    }

    boolean supportsLog() {
        if (this.fDebugTarget.supportsCommandLog()) {
            this.fSupportsLog = true;
        }
        return this.fSupportsLog;
    }

    public PDTDebugTarget getTarget() {
        return this.fDebugTarget;
    }

    String[] getCommandHistory() {
        return this.fCommandHistory.toArray(new String[this.fCommandHistory.size()]);
    }

    public LogLine[] getLogLines() {
        return this.fLogLines.toArray(new LogLine[this.fLogLines.size()]);
    }

    public void addToLogLines(String line, boolean isInput) {
        this.fLogLines.add(new LogLine(line, isInput));
    }

    public void addToCommandHistory(String line) {
        this.fCommandHistory.add(line);
    }

    void clearCommandHistory() {
        this.fCommandHistory.clear();
    }

    String[] getCommandFieldHistory() {
        return this.fCommandFieldHistory;
    }

    void setCommandFieldHistory(String[] history) {
        this.fCommandFieldHistory = history;
    }

    boolean isIdle() {
        return this.fDebugTarget.isIdle();
    }

    public void commandLogResponse(DebugEngineCommandLogResponseEvent event) {
        String[] lines = event.getResponseLines();
        int i = 0;
        while (i < lines.length) {
            this.addToLogLines(DebugConsoleUtils.cleanLine(lines[i]), false);
            ++i;
        }
    }

    public void debugEngineTerminated(DebugEngineTerminatedEvent event) {
        event.getDebugEngine().removeListener((IModelEventListener)this);
    }

    public void modelStateChanged(ModelStateReadyEvent event) {
    }
}

