/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.views;

import com.ibm.debug.pdt.internal.common.CommonUtils;
import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.PDTPendingElement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class BasicDebugViewContentProvider
implements ITreeContentProvider,
IDebugEventSetListener {
    protected static final Object[] EMPTYOBJECTS = new Object[0];
    protected static final Object[] PENDING = new Object[]{new PDTPendingElement()};
    protected TreeViewer fViewer;
    protected boolean fDisposed = false;
    protected HashMap<IDebugElement, List<Object>> fPendingRequests = new HashMap();

    public void dispose() {
        this.fDisposed = true;
    }

    protected boolean isDisposed() {
        return this.fDisposed;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = (TreeViewer)viewer;
    }

    protected void refresh() {
        if (this.fViewer == null || this.isDisposed()) {
            return;
        }
        this.fViewer.refresh();
    }

    protected void refresh(Object element) {
        if (this.fViewer == null || this.isDisposed()) {
            return;
        }
        this.fViewer.refresh(element);
    }

    protected abstract void doHandleDebugEvent(DebugEvent var1);

    public void handleDebugEvents(DebugEvent[] events) {
        if (this.fViewer == null || this.isDisposed()) {
            return;
        }
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            Display display = ctrl.getDisplay();
            int i = 0;
            while (i < events.length) {
                final DebugEvent event = events[i];
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BasicDebugViewContentProvider.this.doHandleDebugEvent(event);
                    }
                });
                ++i;
            }
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        return ((PDTDebugElement)element).getParentElement();
    }

    public boolean hasChildren(Object element) {
        return ((PDTDebugElement)element).hasChildren();
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = this.getChildRequest((IDebugElement)parentElement);
        if (children == null) {
            GetChildrenJob job = new GetChildrenJob(this, (IDebugElement)parentElement);
            job.schedule();
            return PENDING;
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putChildRequest(IDebugElement parent, Object[] children) {
        HashMap<IDebugElement, List<Object>> hashMap = this.fPendingRequests;
        synchronized (hashMap) {
            this.fPendingRequests.put(parent, Arrays.asList(children));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] getChildRequest(IDebugElement parent) {
        HashMap<IDebugElement, List<Object>> hashMap = this.fPendingRequests;
        synchronized (hashMap) {
            List<Object> children;
            block5: {
                children = this.fPendingRequests.get(parent);
                if (children != null) break block5;
                this.fPendingRequests.put(parent, Arrays.asList(PENDING));
                return null;
            }
            if (children.contains(PENDING)) {
                return PENDING;
            }
            this.fPendingRequests.remove(parent);
            return children.toArray(new Object[children.size()]);
        }
    }

    protected Object[] getChildrenJob(BasicDebugViewContentProvider contentProvider, IDebugElement parent) throws Exception {
        return ((PDTDebugElement)parent).getChildren();
    }

    static class GetChildrenJob
    extends Job {
        private final BasicDebugViewContentProvider fContentProvider;
        private final IDebugElement fParent;

        GetChildrenJob(BasicDebugViewContentProvider contentprovider, IDebugElement parent) {
            super("Get Children");
            this.setSystem(true);
            this.fContentProvider = contentprovider;
            this.fParent = parent;
        }

        public IStatus run(IProgressMonitor monitor) {
            Object[] children = EMPTYOBJECTS;
            try {
                children = this.fContentProvider.getChildrenJob(this.fContentProvider, this.fParent);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fContentProvider.putChildRequest(this.fParent, children);
            CommonUtils.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    fContentProvider.refresh(fParent);
                }
            });
            return Status.OK_STATUS;
        }
    }
}

