/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.util;

import com.ibm.debug.pdt.internal.ui.util.DialogField;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class StringCombo
extends DialogField {
    private String fText = "";
    private Combo fComboControl;
    private ModifyListener fModifyListener;

    public StringCombo() {
    }

    public StringCombo(boolean labelBesideButton) {
        super(labelBesideButton);
    }

    @Override
    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        return this.doFillIntoGrid(parent, nColumns, false);
    }

    public Control[] doFillIntoGrid(Composite parent, int nColumns, boolean makeComboEditable) {
        this.assertEnoughColumns(nColumns);
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)StringCombo.gridDataForLabel(1));
        if (!this.fLabelBeside) {
            DialogField.createEmptySpace(parent, nColumns - 1);
        }
        Combo combo = this.getComboControl(parent, makeComboEditable);
        if (this.fLabelBeside) {
            combo.setLayoutData((Object)StringCombo.gridDataForCombo(nColumns - 1));
        } else {
            combo.setLayoutData((Object)StringCombo.gridDataForCombo(nColumns));
        }
        return new Control[]{label, combo};
    }

    @Override
    public int getNumberOfControls() {
        return 2;
    }

    protected static GridData gridDataForCombo(int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = span;
        return gd;
    }

    @Override
    public boolean setFocus() {
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.setSelection(new Point(0, this.fComboControl.getText().length()));
            this.fComboControl.setFocus();
        }
        return true;
    }

    public Combo getComboControl(Composite parent) {
        return this.getComboControl(parent, false);
    }

    public Combo getComboControl(Composite parent, boolean makeComboEditable) {
        if (this.fComboControl == null) {
            this.assertCompositeNotNull(parent);
            this.fModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    StringCombo.this.doModifyText(e);
                }
            };
            int comboStyle = 4;
            if (makeComboEditable) {
                comboStyle |= 4;
            }
            this.fComboControl = new Combo(parent, comboStyle);
            this.fComboControl.setFont(parent.getFont());
            this.fComboControl.addModifyListener(this.fModifyListener);
            this.fComboControl.setText(this.fText);
            this.fComboControl.setEnabled(this.isEnabled());
        }
        return this.fComboControl;
    }

    void doModifyText(ModifyEvent e) {
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fText = this.fComboControl.getText();
        }
        this.dialogFieldChanged();
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.setEnabled(this.isEnabled());
        }
    }

    public String getText() {
        return this.fText;
    }

    public void setText(String text) {
        this.fText = text;
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.setText(text);
        } else {
            this.dialogFieldChanged();
        }
    }

    public void setTextWithoutUpdate(String text) {
        this.fText = text;
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.removeModifyListener(this.fModifyListener);
            this.fComboControl.setText(text);
            this.fComboControl.addModifyListener(this.fModifyListener);
        }
    }

    public void setItems(String[] items) {
        this.fComboControl.setItems(items);
    }
}

