/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.util;

import com.ibm.debug.pdt.internal.ui.PICLUtils;
import org.eclipse.core.runtime.IStatus;

public class StatusInfo
implements IStatus {
    private String fStatusMessage;
    private int fSeverity;
    private Throwable fException;

    public StatusInfo() {
        this.setOK();
    }

    public IStatus[] getChildren() {
        return new IStatus[0];
    }

    public int getCode() {
        return this.fSeverity;
    }

    public Throwable getException() {
        return this.fException;
    }

    public String getMessage() {
        return this.fStatusMessage;
    }

    public String getPlugin() {
        return PICLUtils.getModelIdentifier();
    }

    public int getSeverity() {
        return this.fSeverity;
    }

    public boolean isError() {
        return this.fSeverity == 4;
    }

    public boolean isInfo() {
        return this.fSeverity == 1;
    }

    public boolean isMultiStatus() {
        return false;
    }

    public boolean isOK() {
        return this.fSeverity == 0;
    }

    public boolean isWarning() {
        return this.fSeverity == 2;
    }

    public boolean matches(int severityMask) {
        return (this.fSeverity & severityMask) != 0;
    }

    public void setCancelled(String cancelledMessage) {
        this.setStatus(8, cancelledMessage, null);
    }

    public void setError(String errorMessage) {
        this.setStatus(4, errorMessage, null);
    }

    public void setError(String errorMessage, Throwable exception) {
        this.setStatus(4, errorMessage, exception);
    }

    public void setInfo(String infoMessage) {
        this.setStatus(1, infoMessage, null);
    }

    public void setInfo(String infoMessage, Throwable exception) {
        this.setStatus(1, infoMessage, exception);
    }

    public void setOK() {
        this.setStatus(0, null, null);
    }

    public void setWarning(String warningMessage) {
        this.setStatus(2, warningMessage, null);
    }

    public void setWarning(String warningMessage, Throwable exception) {
        this.setStatus(2, warningMessage, exception);
    }

    private void setStatus(int severity, String message, Throwable exception) {
        this.fSeverity = severity;
        this.fStatusMessage = message;
        this.fException = exception;
    }
}

