/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.util;

import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;

public class PerspectiveCleanupUtils {
    private static final String PREF_KEY = "PerspectiveCleanupUtils.actionsSets.";

    public static final void removeActionSetFromAllPerspectives(final String actionSetId) {
        if (PerspectiveCleanupUtils.isCheckNeeded(actionSetId)) {
            Job removeJob = new Job("Removing " + actionSetId){
                IWorkbenchWindow window;
                {
                    super($anonymous0);
                    this.window = null;
                }

                protected IStatus run(IProgressMonitor arg0) {
                    this.getWindow();
                    while (this.window == null) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            return Status.CANCEL_STATUS;
                        }
                        this.getWindow();
                    }
                    if (this.window instanceof WorkbenchWindow) {
                        EModelService modelService;
                        MApplication application = (MApplication)this.window.getService(MApplication.class);
                        MWindow activeWin = application == null ? null : (MWindow)application.getSelectedElement();
                        MWindow mWindow = ((WorkbenchWindow)this.window).getModel();
                        IEclipseContext context = mWindow.getContext();
                        EModelService eModelService = modelService = context == null ? null : (EModelService)context.get(EModelService.class);
                        if (modelService != null && activeWin != null) {
                            List perspectives = modelService.findElements((MUIElement)activeWin, null, MPerspective.class, null);
                            for (MPerspective perspective : perspectives) {
                                ArrayList<String> toRemove = new ArrayList<String>();
                                for (String tag : perspective.getTags()) {
                                    if (!tag.startsWith("persp.actionSet:") || !tag.substring("persp.actionSet:".length()).endsWith(actionSetId)) continue;
                                    toRemove.add(tag);
                                }
                                if (toRemove.size() <= 0) continue;
                                perspective.getTags().removeAll(toRemove);
                            }
                        }
                    }
                    PerspectiveCleanupUtils.setCheckNotNeeded(actionSetId);
                    return Status.OK_STATUS;
                }

                private void getWindow() {
                    if (Display.getDefault() != null) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            }
                        });
                    }
                }
            };
            removeJob.setSystem(true);
            removeJob.schedule();
        }
    }

    private static boolean isCheckNeeded(String actionSetId) {
        String key = PREF_KEY + actionSetId;
        return !PICLDebugPlugin.getInstance().getPreferenceStore().getBoolean(key);
    }

    private static void setCheckNotNeeded(String actionSetId) {
        String key = PREF_KEY + actionSetId;
        PICLDebugPlugin.getInstance().getPreferenceStore().setValue(key, true);
    }
}

