/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.util;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.engine.EngineIdentifier;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class DisconnectUIUtils {
    private static boolean fInitialized = false;
    private static final Map<EngineIdentifier, List<DisconnectPrompt>> fDisconnectPrompts = new HashMap<EngineIdentifier, List<DisconnectPrompt>>();
    private static int fDisconnectAction = 0;

    private static void initialize() {
        if (!fInitialized) {
            IConfigurationElement[] configElements;
            fInitialized = true;
            IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.debug.pdt.ui.disconnectPrompt");
            int n = configElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                try {
                    short type = Short.parseShort(configurationElement.getAttribute("type"));
                    short os = Short.parseShort(configurationElement.getAttribute("os"));
                    short hardware = Short.parseShort(configurationElement.getAttribute("hw"));
                    EngineIdentifier engineId = new EngineIdentifier(type, os, hardware);
                    ArrayList<DisconnectPrompt> prompts = new ArrayList<DisconnectPrompt>();
                    IConfigurationElement[] iConfigurationElementArray2 = configurationElement.getChildren("promptMapping");
                    int n3 = iConfigurationElementArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement children = iConfigurationElementArray2[n4];
                        DisconnectPrompt prompt = new DisconnectPrompt();
                        prompt.fPrompt = children.getAttribute("prompt");
                        prompt.fDisconnectAction = Integer.parseInt(children.getAttribute("disconnectType"));
                        prompts.add(prompt);
                        ++n4;
                    }
                    if (prompts.size() > 1) {
                        fDisconnectPrompts.put(engineId, prompts);
                    } else {
                        PICLUtils.logString(DisconnectUIUtils.class, "Disconnect extension point did not have enough prompts defined:" + configurationElement.getName());
                    }
                }
                catch (Exception e) {
                    PICLUtils.logError(e);
                }
                ++n2;
            }
        }
    }

    public static boolean supportsPrompt(EPDC_EngineSession engineSession) {
        if (engineSession.supportsProcessDetachRelease() && (engineSession.supportsProcessDetachKill() || engineSession.supportsProcessDetachKeep()) || engineSession.supportsProcessDetachKill() && engineSession.supportsProcessDetachKeep()) {
            DisconnectUIUtils.initialize();
            EngineIdentifier id = new EngineIdentifier((short)engineSession.getEngineID(), (short)engineSession.getEngineOS(), (short)engineSession.getEngineHardware());
            for (EngineIdentifier key : fDisconnectPrompts.keySet()) {
                if (!key.equals((Object)id)) continue;
                return true;
            }
        }
        return false;
    }

    public static synchronized int promptForDisconnectAction(EPDC_EngineSession engineSession) {
        DisconnectUIUtils.initialize();
        final List<DisconnectPrompt> prompts = DisconnectUIUtils.getPrompts(engineSession);
        fDisconnectAction = 0;
        if (prompts != null && prompts.size() > 1) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), PICLLabels.Disconnect_title, null, PICLMessages.CRRDG3259, 3, 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}){

                        protected Control createCustomArea(Composite parent) {
                            boolean first = true;
                            for (final DisconnectPrompt p : prompts) {
                                Button b = new Button(parent, 16);
                                GridDataFactory.swtDefaults().indent(45, -1).applyTo((Control)b);
                                b.setText(p.fPrompt);
                                if (first) {
                                    first = false;
                                    b.setSelection(true);
                                    fDisconnectAction = p.fDisconnectAction;
                                }
                                b.addSelectionListener(new SelectionListener(){

                                    public void widgetSelected(SelectionEvent arg0) {
                                        fDisconnectAction = p.fDisconnectAction;
                                    }

                                    public void widgetDefaultSelected(SelectionEvent arg0) {
                                        fDisconnectAction = p.fDisconnectAction;
                                    }
                                });
                            }
                            return super.createCustomArea(parent);
                        }
                    };
                    if (dialog.open() != 0) {
                        fDisconnectAction = -1;
                    }
                }
            });
            return fDisconnectAction;
        }
        return 0;
    }

    private static List<DisconnectPrompt> getPrompts(EPDC_EngineSession engineSession) {
        EngineIdentifier id = new EngineIdentifier((short)engineSession.getEngineID(), (short)engineSession.getEngineOS(), (short)engineSession.getEngineHardware());
        for (Map.Entry<EngineIdentifier, List<DisconnectPrompt>> entry : fDisconnectPrompts.entrySet()) {
            if (!entry.getKey().equals((Object)id)) continue;
            return entry.getValue();
        }
        return null;
    }

    private static class DisconnectPrompt {
        String fPrompt;
        int fDisconnectAction;

        private DisconnectPrompt() {
        }
    }
}

